/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.util.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalizeStringResourcesProcessor {
    public void process(AnnotationProcessorEnvironment env) {
        for (TypeDeclaration type : ExternalizeStringResourcesProcessor.getAnnotatedTypes(env)) {
            HashSet<String> strings = new HashSet<String>();
            ExternalizeStringResourcesProcessor.gather(strings, (Label)type.getAnnotation(Label.class));
            ExternalizeStringResourcesProcessor.gather(strings, (Documentation)type.getAnnotation(Documentation.class));
            for (FieldDeclaration field : type.getFields()) {
                String fieldName = field.getSimpleName();
                if (fieldName == null) continue;
                ExternalizeStringResourcesProcessor.gather(strings, (Label)field.getAnnotation(Label.class));
                if (!fieldName.startsWith("PROP_")) continue;
                ExternalizeStringResourcesProcessor.gather(strings, (Documentation)field.getAnnotation(Documentation.class));
                ExternalizeStringResourcesProcessor.gather(strings, (NamedValues)field.getAnnotation(NamedValues.class));
            }
            if (strings.isEmpty()) continue;
            Properties resources = new Properties();
            for (String string : strings) {
                resources.put(MiscUtil.createStringDigest((String)string), string);
            }
            String pkg = type.getPackage().getQualifiedName();
            String relpath = ExternalizeStringResourcesProcessor.generateFileName(type);
            PrintWriter pw = null;
            try {
                try {
                    pw = env.getFiler().createTextFile(Filer.Location.CLASS_TREE, pkg, new File(relpath), null);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    resources.store(baos, null);
                    String s = baos.toString();
                    pw.print(s);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (pw == null) continue;
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (pw == null) continue;
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String generateFileName(TypeDeclaration type) {
        String qname = type.getQualifiedName();
        String pkg = type.getPackage().getQualifiedName();
        if (pkg.length() == 0) {
            return qname;
        }
        return String.valueOf(qname.substring(pkg.length() + 1).replace('.', '$')) + ".properties";
    }

    private static Set<TypeDeclaration> getAnnotatedTypes(AnnotationProcessorEnvironment env) {
        HashSet<TypeDeclaration> annotatedTypes = new HashSet<TypeDeclaration>();
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)env.getTypeDeclaration(Label.class.getName());
        if (annotationDeclaration == null) {
            return annotatedTypes;
        }
        Collection annotatedDeclarations = env.getDeclarationsAnnotatedWith(annotationDeclaration);
        if (annotatedDeclarations == null) {
            return annotatedTypes;
        }
        for (Declaration decl : annotatedDeclarations) {
            for (AnnotationMirror annotation : decl.getAnnotationMirrors()) {
                if (!annotation.getAnnotationType().getDeclaration().getQualifiedName().equals(Label.class.getName())) continue;
                if (decl instanceof TypeDeclaration) {
                    annotatedTypes.add((TypeDeclaration)decl);
                    continue;
                }
                if (decl instanceof FieldDeclaration) {
                    annotatedTypes.add(((FieldDeclaration)decl).getDeclaringType());
                    continue;
                }
                throw new IllegalStateException(decl.getClass().getName());
            }
        }
        return annotatedTypes;
    }

    private static void gather(Set<String> strings, Label labelAnnotation) {
        if (labelAnnotation != null) {
            String fullLabel;
            String standardLabel = labelAnnotation.standard();
            if (standardLabel.length() > 0) {
                strings.add(standardLabel);
            }
            if ((fullLabel = labelAnnotation.full()).length() > 0) {
                strings.add(fullLabel);
            }
        }
    }

    private static void gather(Set<String> strings, Documentation documentationAnnotation) {
        if (documentationAnnotation != null) {
            String content = documentationAnnotation.content();
            if (content.length() > 0) {
                strings.add(content);
            }
            Documentation.Topic[] topicArray = documentationAnnotation.topics();
            int n = topicArray.length;
            int n2 = 0;
            while (n2 < n) {
                Documentation.Topic topic = topicArray[n2];
                strings.add(topic.label());
                ++n2;
            }
        }
    }

    private static void gather(Set<String> strings, NamedValues namedValuesAnnotation) {
        if (namedValuesAnnotation != null) {
            strings.add(namedValuesAnnotation.arbitraryValueLabel());
            NamedValues.NamedValue[] namedValueArray = namedValuesAnnotation.namedValues();
            int n = namedValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedValues.NamedValue val = namedValueArray[n2];
                strings.add(val.label());
                ++n2;
            }
        }
    }
}

