/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;

public abstract class SapphirePropertyEditorActionHandler
extends SapphireActionHandler {
    private Listener listener;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                SapphirePropertyEditorActionHandler.this.refreshEnablementState();
            }
        };
        this.getModelElement().attach(this.listener, this.getProperty());
        this.refreshEnablementState();
        this.attach((Listener)new FilteredListener<DisposeEvent>(){

            protected void handleTypedEvent(DisposeEvent event) {
                SapphirePropertyEditorActionHandler.this.getModelElement().detach(SapphirePropertyEditorActionHandler.this.listener, SapphirePropertyEditorActionHandler.this.getProperty());
            }
        });
    }

    public final IModelElement getModelElement() {
        return ((PropertyEditorPart)this.getPart()).getLocalModelElement();
    }

    public ModelProperty getProperty() {
        return ((PropertyEditorPart)this.getPart()).getProperty();
    }

    public final void refreshEnablementState() {
        Runnable op = new Runnable(){

            public void run() {
                SapphirePropertyEditorActionHandler.this.setEnabled(SapphirePropertyEditorActionHandler.this.computeEnablementState());
            }
        };
        SwtUtil.runOnDisplayThread(op);
    }

    protected boolean computeEnablementState() {
        return this.getModelElement().enabled(this.getProperty());
    }
}

