/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactoryProxy;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.def.ServiceDef;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.SetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PartServiceContext
extends ServiceContext {
    private final ISapphirePart part;

    public PartServiceContext(ISapphirePart part) {
        super("Sapphire.Part", null);
        this.part = part;
    }

    public <T> T find(Class<T> type) {
        Object obj = super.find(type);
        if (obj == null) {
            IModelElement element;
            if (type.isInstance(this.part)) {
                obj = type.cast(this.part);
            } else if (IModelElement.class.isAssignableFrom(type) && (element = this.part.getLocalModelElement()) != null) {
                obj = type == IModelElement.class ? type.cast(element) : element.nearest(type);
            }
        }
        return (T)obj;
    }

    protected List<ServiceFactoryProxy> local() {
        ListFactory local = ListFactory.start();
        PartDef partDef = this.part.definition();
        for (ServiceDef serviceDef : partDef.getServices()) {
            final Class serviceImplClass = PartServiceContext.resolve(serviceDef.getImplementation());
            SetFactory overridesSetFactory = SetFactory.start();
            for (ServiceDef.Override override : serviceDef.getOverrides()) {
                String id = override.getId().getText();
                if (id == null || (id = id.trim()).length() <= 0) continue;
                overridesSetFactory.add((Object)id);
            }
            final Set overrides = overridesSetFactory.result();
            if (serviceImplClass == null) continue;
            ServiceFactoryProxy proxy = new ServiceFactoryProxy(){

                public String id() {
                    return serviceImplClass.getName();
                }

                public Class<? extends Service> type() {
                    return serviceImplClass;
                }

                public Set<String> overrides() {
                    return overrides;
                }

                protected Service createHandOff(ServiceContext context, Class<? extends Service> service) {
                    Service instance = null;
                    try {
                        instance = (Service)serviceImplClass.newInstance();
                    }
                    catch (Exception e) {
                        LoggingService.log((Exception)e);
                    }
                    return instance;
                }
            };
            local.add((Object)proxy);
        }
        return local.result();
    }

    private static <T> Class<T> resolve(ReferenceValue<JavaTypeName, JavaType> ref) {
        JavaType type = (JavaType)ref.resolve();
        return type != null ? type.artifact() : null;
    }
}

