/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JdtUtil {
    private JdtUtil() {
    }

    public static IContainer findSourceFolder(IResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        IProject project = resource.getProject();
        if (project == null) {
            throw new IllegalArgumentException();
        }
        List<IContainer> sourceFolders = JdtUtil.findSourceFolders(project);
        IPath resourceFullPath = resource.getFullPath();
        for (IContainer sourceFolder : sourceFolders) {
            if (!sourceFolder.getFullPath().isPrefixOf(resourceFullPath)) continue;
            return sourceFolder;
        }
        for (IContainer sourceFolder : sourceFolders) {
            if (sourceFolder.isDerived()) continue;
            return sourceFolder;
        }
        return null;
    }

    public static List<IContainer> findSourceFolders(IResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        IProject project = resource.getProject();
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return JdtUtil.findSourceFolders(project);
    }

    public static List<IContainer> findSourceFolders(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return JdtUtil.findSourceFolders(JavaCore.create((IProject)project));
    }

    public static List<IContainer> findSourceFolders(IJavaProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        ListFactory sourceFolders = ListFactory.start();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource sourceFolderResource;
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 3 && (sourceFolderResource = root.findMember(cpe.getPath())) instanceof IContainer) {
                    sourceFolders.add((Object)((IContainer)sourceFolderResource));
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return ListFactory.empty();
        }
        return sourceFolders.result();
    }
}

