/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import java.util.EnumSet;
import java.util.HashSet;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeConstraintServiceData;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class StandardJavaTypeConstraintService
extends JavaTypeConstraintService {
    private JavaTypeConstraintServiceData data;

    protected void initJavaTypeConstraintService() {
        ModelProperty property = (ModelProperty)this.context().find(ModelProperty.class);
        JavaTypeConstraint javaTypeConstraintAnnotation = (JavaTypeConstraint)property.getAnnotation(JavaTypeConstraint.class);
        EnumSet<JavaTypeKind> kind = EnumSet.noneOf(JavaTypeKind.class);
        JavaTypeKind[] javaTypeKindArray = javaTypeConstraintAnnotation.kind();
        int n = javaTypeKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaTypeKind k = javaTypeKindArray[n2];
            kind.add(k);
            ++n2;
        }
        HashSet<String> type = new HashSet<String>();
        String[] stringArray = javaTypeConstraintAnnotation.type();
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String t = stringArray[n];
            if (t != null && (t = t.trim()).length() > 0) {
                type.add(t);
            }
            ++n;
        }
        this.data = new JavaTypeConstraintServiceData(kind, type, javaTypeConstraintAnnotation.behavior());
    }

    protected JavaTypeConstraintServiceData compute() {
        return this.data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            JavaTypeConstraint constraintAnnotation;
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && property.getTypeClass() == JavaTypeName.class && (constraintAnnotation = (JavaTypeConstraint)property.getAnnotation(JavaTypeConstraint.class)) != null;
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StandardJavaTypeConstraintService();
        }
    }
}

