/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ClearOnDisable;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.AdapterService;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DependenciesAggregationService;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EqualityService;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationAggregationService;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.services.internal.ElementInstanceServiceContext;
import org.eclipse.sapphire.services.internal.PropertyInstanceServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElement
extends ModelParticle
implements IModelElement {
    private final ModelElementType type;
    private final ModelProperty parentProperty;
    private final Map<ModelProperty, Object> properties;
    private Status validation;
    private final ListenerContext listeners = new ListenerContext();
    private ElementInstanceServiceContext elementServiceContext;
    private final Map<ModelProperty, PropertyInstanceServiceContext> propertyServiceContexts;
    private boolean disposed = false;

    public ModelElement(ModelElementType type, IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(parent, resource);
        this.type = type;
        this.parentProperty = parentProperty;
        this.properties = new HashMap<ModelProperty, Object>(this.type.properties().size());
        this.validation = null;
        this.propertyServiceContexts = new HashMap<ModelProperty, PropertyInstanceServiceContext>();
        if (parent != null) {
            ModelElement p = (ModelElement)parent.nearest(IModelElement.class);
            this.listeners.coordinate(p.listeners);
        }
        resource.init(this);
        for (Listener listener : this.type.listeners()) {
            this.attach(listener);
        }
        for (ModelProperty property : this.type.properties()) {
            for (Listener listener : property.listeners()) {
                this.attach(listener, property);
            }
        }
        this.attach(new PropertyInitializationListener());
    }

    @Override
    public ModelElementType type() {
        return this.type;
    }

    @Override
    public ModelProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public final <T extends IModelElement> T initialize() {
        for (ModelProperty property : this.properties()) {
            if (property instanceof ValueProperty) {
                InitialValueService initialValueService = this.service(property, InitialValueService.class);
                if (initialValueService == null) continue;
                this.write(property, (Object)initialValueService.value());
                continue;
            }
            if (!(property instanceof ImpliedElementProperty)) continue;
            this.read((ImpliedElementProperty)property).element().initialize();
        }
        return (T)this;
    }

    @Override
    public List<ModelProperty> properties() {
        return this.type.properties();
    }

    @Override
    public <T extends ModelProperty> T property(String name) {
        return this.type.property(name);
    }

    @Override
    public final Object read(ModelProperty property) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.read(property.getName());
    }

    @Override
    public final Object read(String property) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        Object data = this.properties.get(prop);
        if (data == null) {
            this.refresh((ModelProperty)prop, true);
        }
        data = this.properties.get(prop);
        return data;
    }

    @Override
    public final <T> Value<T> read(ValueProperty property) {
        this.assertNotDisposed();
        return (Value)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> ModelElementHandle<T> read(ElementProperty property) {
        this.assertNotDisposed();
        return (ModelElementHandle)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> ModelElementList<T> read(ListProperty property) {
        this.assertNotDisposed();
        return (ModelElementList)this.read((ModelProperty)property);
    }

    @Override
    public final <T> Transient<T> read(TransientProperty property) {
        this.assertNotDisposed();
        return (Transient)this.read((ModelProperty)property);
    }

    @Override
    public final SortedSet<String> read(ModelPath path) {
        this.assertNotDisposed();
        TreeSet<String> result = new TreeSet<String>();
        this.read(path, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(ModelPath path, Collection<String> result) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            this.assertNotDisposed();
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).read(path.tail(), result);
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).read(path.tail(), result);
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.getParentProperty().getName()).append(path.tail());
                ((IModelElement)parent).read(p, result);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.properties()) {
                    Object obj = this.read(property);
                    if (obj instanceof Value) {
                        String val = ((Value)obj).getText();
                        if (val == null) continue;
                        result.add(val);
                        continue;
                    }
                    if (obj instanceof IModelElement) {
                        ((IModelElement)obj).read(path, result);
                        continue;
                    }
                    if (!(obj instanceof ModelElementList)) continue;
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path, result);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type().getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.read(path.tail(), result);
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                Object property = this.property(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Object obj = this.read((ModelProperty)property);
                if (obj instanceof Value) {
                    String val = ((Value)obj).getText();
                    if (val != null) {
                        result.add(val);
                    }
                    if (path.length() != 1) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                } else if (obj instanceof IModelElement) {
                    ((IModelElement)obj).read(path.tail(), result);
                } else if (obj instanceof ModelElementList) {
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path.tail(), result);
                    }
                }
            }
        }
    }

    @Override
    public final void write(ModelProperty property, Object content) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.write(property.getName(), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(String property, Object content) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (prop instanceof ValueProperty) {
                ValueProperty p = (ValueProperty)prop;
                String value = null;
                if (content != null) {
                    if (content instanceof String) {
                        value = (String)content;
                    } else if (p.getTypeClass().isInstance(content)) {
                        value = this.service(p, ValueSerializationMasterService.class).encode(content);
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                value = p.decodeKeywords(value);
                value = this.service(p, ValueNormalizationService.class).normalize(value);
                if (!ModelElement.equal(this.read(p).getText(false), value)) {
                    this.resource().binding(p).write(value);
                    this.refresh(p);
                }
            } else if (prop instanceof TransientProperty) {
                TransientProperty p = (TransientProperty)prop;
                Transient oldTransient = (Transient)this.properties.get(p);
                Transient t = new Transient(this, p, content);
                this.properties.put(p, t);
                t.init();
                if (!this.disposed()) {
                    if (oldTransient == null) {
                        this.post(new PropertyInitializationEvent(this, p));
                        if (content != null) {
                            this.post(new PropertyContentEvent(this, p));
                        }
                    } else if (t.equals(oldTransient)) {
                        t = oldTransient;
                        this.properties.put(p, t);
                    } else {
                        if (!MiscUtil.equal(t.content(), oldTransient.content())) {
                            this.post(new PropertyContentEvent(this, p));
                        }
                        if (t.enabled() != oldTransient.enabled()) {
                            this.post(new PropertyEnablementEvent(this, p, oldTransient.enabled(), t.enabled()));
                        }
                        if (!t.validation().equals(oldTransient.validation())) {
                            this.post(new PropertyValidationEvent(this, p, oldTransient.validation(), t.validation()));
                        }
                    }
                    this.broadcast();
                }
            } else {
                String msg = NLS.bind(Resources.cannotWriteProperty, property);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    @Override
    public final void refresh() {
        this.assertNotDisposed();
        this.refresh(false, false);
    }

    @Override
    public final void refresh(boolean force) {
        this.assertNotDisposed();
        this.refresh(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(boolean force, boolean deep) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            this.assertNotDisposed();
            for (ModelProperty property : this.properties()) {
                if (this.disposed()) break;
                this.refresh(property, force, deep);
            }
        }
    }

    @Override
    public final void refresh(ModelProperty property) {
        this.assertNotDisposed();
        this.refresh(property, false, false);
    }

    @Override
    public final void refresh(String property) {
        this.assertNotDisposed();
        this.refresh(property, false, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force) {
        this.assertNotDisposed();
        this.refresh(property, force, false);
    }

    @Override
    public final void refresh(String property, boolean force) {
        this.assertNotDisposed();
        this.refresh(property, force, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force, boolean deep) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.refresh(property.getName(), force, deep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(String property, boolean force, boolean deep) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelProperty p;
            if (prop instanceof ValueProperty) {
                p = (ValueProperty)prop;
                Value value = (ReferenceValue)this.properties.get(p);
                if (value != null || force) {
                    ReferenceValue oldValue = value;
                    String val = p.hasAnnotation(Derived.class) ? this.service(p, DerivedValueService.class).value() : this.resource().binding((ValueProperty)p).read();
                    val = this.service(p, ValueNormalizationService.class).normalize(((ValueProperty)p).encodeKeywords(val));
                    value = p.hasAnnotation(Reference.class) ? new ReferenceValue(this, (ValueProperty)p, val) : new Value(this, (ValueProperty)p, val);
                    this.properties.put(p, value);
                    value.init();
                    if (!this.disposed()) {
                        if (oldValue == null) {
                            this.post(new PropertyInitializationEvent(this, p));
                        } else if (value.equals(oldValue)) {
                            value = oldValue;
                            this.properties.put(p, value);
                        } else {
                            if (!ModelElement.equal(value.getText(false), oldValue.getText(false)) || !ModelElement.equal(value.getDefaultText(), oldValue.getDefaultText())) {
                                this.post(new PropertyContentEvent(this, p));
                            }
                            if (value.enabled() != oldValue.enabled()) {
                                this.post(new PropertyEnablementEvent(this, p, oldValue.enabled(), value.enabled()));
                            }
                            if (!value.validation().equals(oldValue.validation())) {
                                this.post(new PropertyValidationEvent(this, p, oldValue.validation(), value.validation()));
                            }
                        }
                        this.broadcast();
                    }
                }
            } else if (prop instanceof ElementProperty) {
                p = (ElementProperty)prop;
                ModelElementHandle handle = (ModelElementHandle)this.properties.get(p);
                if (handle == null) {
                    if (force) {
                        handle = new ModelElementHandle(this, (ElementProperty)p);
                        this.properties.put(p, handle);
                        handle.init();
                        this.broadcast(new PropertyInitializationEvent(this, p));
                    }
                } else {
                    handle.refresh();
                }
            } else if (prop instanceof ListProperty) {
                p = (ListProperty)prop;
                ModelElementList list = (ModelElementList)this.properties.get(p);
                if (list == null) {
                    if (force) {
                        list = new ModelElementList(this, (ListProperty)p);
                        this.properties.put(p, list);
                        list.init(this.resource().binding((ListProperty)p));
                        this.broadcast(new PropertyInitializationEvent(this, p));
                    }
                } else {
                    list.refresh();
                }
            } else if (prop instanceof TransientProperty) {
                Transient t = (Transient)this.properties.get(prop);
                if (t == null) {
                    if (force) {
                        this.write((ModelProperty)prop, (Object)null);
                    }
                } else {
                    this.write((ModelProperty)prop, t.content());
                }
            } else {
                throw new IllegalStateException();
            }
        }
        if (deep) {
            if (prop instanceof ElementProperty) {
                Object child = this.read((ElementProperty)prop).element();
                if (child != null) {
                    child.refresh(force, true);
                }
            } else if (prop instanceof ListProperty) {
                for (Object child : this.read((ListProperty)prop)) {
                    child.refresh(force, true);
                }
            }
        }
    }

    @Override
    public final void copy(IModelElement element) {
        this.assertNotDisposed();
        if (this.type != element.type()) {
            throw new IllegalArgumentException();
        }
        for (ModelProperty property : this.type.properties()) {
            ModelProperty prop;
            if (property.isReadOnly()) continue;
            if (property instanceof ValueProperty) {
                prop = (ValueProperty)property;
                this.write(prop, (Object)element.read((ValueProperty)prop).getText(false));
                continue;
            }
            if (property instanceof ImpliedElementProperty) {
                prop = (ImpliedElementProperty)property;
                this.read((ElementProperty)prop).element().copy((IModelElement)element.read((ElementProperty)prop).element());
                continue;
            }
            if (property instanceof ElementProperty) {
                prop = (ElementProperty)property;
                Object elementChild = element.read((ElementProperty)prop).element();
                ModelElementHandle handle = this.read((ElementProperty)prop);
                if (elementChild == null) {
                    handle.remove();
                    continue;
                }
                Object thisChild = handle.element(true, elementChild.type());
                thisChild.copy((IModelElement)elementChild);
                continue;
            }
            if (property instanceof ListProperty) {
                prop = (ListProperty)property;
                ModelElementList list = this.read((ListProperty)prop);
                list.clear();
                for (IModelElement elementChild : element.read((ListProperty)prop)) {
                    Object thisChild = list.insert(elementChild.type());
                    thisChild.copy(elementChild);
                }
                continue;
            }
            if (!(property instanceof TransientProperty)) continue;
            prop = (TransientProperty)property;
            this.write(prop, element.read((TransientProperty)prop).content());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean equals(Object obj) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            EqualityService equalityService;
            boolean result = false;
            if (this == obj) {
                result = true;
            } else if (obj instanceof IModelElement && !this.disposed() && (equalityService = this.service(EqualityService.class)) != null) {
                result = equalityService.doEquals(obj);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            EqualityService equalityService;
            int result = this.disposed() ? super.hashCode() : ((equalityService = this.service(EqualityService.class)) != null ? equalityService.doHashCode() : super.hashCode());
            return result;
        }
    }

    @Override
    public final <S extends Service> S service(Class<S> serviceType) {
        this.assertNotDisposed();
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends Service> List<S> services(Class<S> serviceType) {
        this.assertNotDisposed();
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.elementServiceContext == null) {
                this.elementServiceContext = new ElementInstanceServiceContext(this);
                this.elementServiceContext.coordinate(this.listeners);
            }
            return this.elementServiceContext.services(serviceType);
        }
    }

    @Override
    public final <S extends Service> S service(ModelProperty property, Class<S> serviceType) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        return this.service(property.getName(), serviceType);
    }

    @Override
    public final <S extends Service> S service(String property, Class<S> serviceType) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        List<S> services = this.services(property, serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    @Override
    public final <S extends Service> List<S> services(ModelProperty property, Class<S> serviceType) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        return this.services(property.getName(), serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends Service> List<S> services(String property, Class<S> serviceType) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (serviceType == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            PropertyInstanceServiceContext context = this.propertyServiceContexts.get(prop);
            if (context == null) {
                context = new PropertyInstanceServiceContext(this, (ModelProperty)prop);
                context.coordinate(this.listeners);
                this.propertyServiceContexts.put((ModelProperty)prop, context);
            }
            return context.services(serviceType);
        }
    }

    @Override
    public final boolean empty(ModelProperty property) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.empty(property.getName());
    }

    @Override
    public final boolean empty(String property) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        if (prop instanceof ValueProperty) {
            return this.read((ValueProperty)prop).getText(false) == null;
        }
        if (prop instanceof ImpliedElementProperty) {
            Object element = this.read((ImpliedElementProperty)prop).element();
            for (ModelProperty p : element.type().properties()) {
                if (element.empty(p)) continue;
                return false;
            }
            return true;
        }
        if (prop instanceof ElementProperty) {
            return this.read((ElementProperty)prop).element() == null;
        }
        if (prop instanceof ListProperty) {
            return this.read((ListProperty)prop).isEmpty();
        }
        if (prop instanceof TransientProperty) {
            return this.read((TransientProperty)prop).content() == null;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean enabled(ModelProperty property) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.enabled(property.getName());
    }

    @Override
    public final boolean enabled(String property) {
        boolean enablement;
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        if (prop instanceof ValueProperty) {
            enablement = this.read((ValueProperty)prop).enabled();
        } else if (prop instanceof ListProperty) {
            enablement = this.read((ListProperty)prop).enabled();
        } else if (prop instanceof ElementProperty) {
            enablement = this.read((ElementProperty)prop).enabled();
        } else if (prop instanceof TransientProperty) {
            enablement = this.read((TransientProperty)prop).enabled();
        } else {
            throw new IllegalStateException();
        }
        return enablement;
    }

    @Override
    public final Status validation(ModelProperty property) {
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.validation(property.getName());
    }

    @Override
    public final Status validation(String property) {
        Status validation;
        this.assertNotDisposed();
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Object prop = this.type.property(property);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        if (prop instanceof ValueProperty) {
            validation = this.read((ValueProperty)prop).validation();
        } else if (prop instanceof ListProperty) {
            validation = this.read((ListProperty)prop).validation();
        } else if (prop instanceof ElementProperty) {
            validation = this.read((ElementProperty)prop).validation();
        } else if (prop instanceof TransientProperty) {
            validation = this.read((TransientProperty)prop).validation();
        } else {
            throw new IllegalStateException();
        }
        return validation;
    }

    @Override
    public final Status validation() {
        this.assertNotDisposed();
        if (this.validation == null) {
            this.refreshValidationResult();
        }
        return this.validation;
    }

    private void refreshValidationResult() {
        ValidationAggregationService service = this.service(ValidationAggregationService.class);
        Status validation = service.validation();
        if (this.validation == null) {
            this.validation = validation;
            Listener validationAggregationServiceListener = new Listener(){

                public void handle(Event event) {
                    ModelElement.this.refreshValidationResult();
                }
            };
            service.attach(validationAggregationServiceListener);
        } else if (!this.validation.equals(validation)) {
            Status oldValidationState = this.validation;
            this.validation = validation;
            this.broadcast(new ElementValidationEvent(this, oldValidationState, this.validation));
        }
    }

    public ListenerContext listeners() {
        return this.listeners;
    }

    @Override
    public final boolean attach(Listener listener) {
        this.assertNotDisposed();
        return this.listeners.attach(listener);
    }

    @Override
    public final void attach(Listener listener, String path) {
        this.assertNotDisposed();
        this.attach(listener, new ModelPath(path));
    }

    @Override
    public final void attach(Listener listener, ModelPath path) {
        this.assertNotDisposed();
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.ModelRootSegment) {
            ((IModelElement)this.root()).attach(listener, path.tail());
        } else if (head instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = this.parent();
            if (parent == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            ((IModelElement)parent).attach(listener, path.tail());
        } else if (head instanceof ModelPath.AllSiblingsSegment) {
            IModelParticle parent = this.parent();
            if (parent == null || !(parent instanceof ModelElementList)) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            parent = parent.parent();
            ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
            ((IModelElement)parent).attach(listener, p);
        } else if (head instanceof ModelPath.AllDescendentsSegment) {
            if (this.attach(new PropagationListener(path, listener))) {
                for (ModelProperty property : this.type.properties()) {
                    if (property instanceof ElementProperty) {
                        Object element = this.read((ElementProperty)property).element();
                        if (element == null) continue;
                        element.attach(listener, path);
                        continue;
                    }
                    if (property instanceof ListProperty) {
                        ModelElementList list = this.read((ListProperty)property);
                        for (IModelElement x : list) {
                            x.attach(listener, path);
                        }
                        continue;
                    }
                    this.attach(PropertyEvent.filter(listener));
                }
            }
        } else if (head instanceof ModelPath.TypeFilterSegment) {
            String t = this.type.getSimpleName();
            boolean match = false;
            for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                if (!type.equalsIgnoreCase(t)) continue;
                match = true;
                break;
            }
            if (match) {
                this.attach(listener, path.tail());
            }
        } else {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            Object property = this.type.property(propertyName);
            if (property == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (path.length() == 1) {
                this.attach(PropertyEvent.filter(listener, property));
            } else {
                ModelPath tail = path.tail();
                if (property instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)property).element().attach(listener, tail);
                } else if (property instanceof ElementProperty) {
                    Object element;
                    if (this.attach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property)) && (element = this.read((ElementProperty)property).element()) != null) {
                        element.attach(listener, tail);
                    }
                } else if (property instanceof ListProperty) {
                    if (this.attach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property))) {
                        ModelElementList list = this.read((ListProperty)property);
                        for (IModelElement x : list) {
                            x.attach(listener, tail);
                        }
                    }
                } else {
                    this.logInvalidModelPathMessage(path);
                }
            }
        }
    }

    @Override
    public final void attach(Listener listener, ModelProperty property) {
        this.assertNotDisposed();
        this.attach(listener, property.getName());
    }

    @Override
    public final boolean detach(Listener listener) {
        if (this.disposed()) {
            return false;
        }
        return this.listeners.detach(listener);
    }

    @Override
    public final void detach(Listener listener, String path) {
        if (this.disposed()) {
            return;
        }
        this.detach(listener, new ModelPath(path));
    }

    @Override
    public final void detach(Listener listener, ModelPath path) {
        if (this.disposed()) {
            return;
        }
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.ModelRootSegment) {
            ((IModelElement)this.root()).detach(listener, path.tail());
        } else if (head instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = this.parent();
            if (parent == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            ((IModelElement)parent).detach(listener, path.tail());
        } else if (head instanceof ModelPath.AllSiblingsSegment) {
            IModelParticle parent = this.parent();
            if (parent == null || !(parent instanceof ModelElementList)) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            parent = parent.parent();
            ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
            ((IModelElement)parent).detach(listener, p);
        } else if (head instanceof ModelPath.AllDescendentsSegment) {
            this.detach(new PropagationListener(path, listener));
            for (ModelProperty property : this.type.properties()) {
                if (property instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)property).element().detach(listener, path);
                    continue;
                }
                if (property instanceof ElementProperty) {
                    Object element = this.read((ElementProperty)property).element();
                    if (element == null) continue;
                    element.detach(listener, path);
                    continue;
                }
                if (property instanceof ListProperty) {
                    ModelElementList list = this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.detach(listener, path);
                    }
                    continue;
                }
                this.detach(PropertyEvent.filter(listener));
            }
        } else if (head instanceof ModelPath.TypeFilterSegment) {
            String t = this.type.getSimpleName();
            boolean match = false;
            for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                if (!type.equalsIgnoreCase(t)) continue;
                match = true;
                break;
            }
            if (match) {
                this.detach(listener, path.tail());
            }
        } else {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            Object property = this.type.property(propertyName);
            if (property == null) {
                this.logInvalidModelPathMessage(path);
                return;
            }
            if (path.length() == 1) {
                this.detach(PropertyEvent.filter(listener, property));
            } else {
                ModelPath tail = path.tail();
                if (property instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)property).element().detach(listener, tail);
                } else if (property instanceof ElementProperty) {
                    this.detach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property));
                    Object element = this.read((ElementProperty)property).element();
                    if (element != null) {
                        element.detach(listener, tail);
                    }
                } else if (property instanceof ListProperty) {
                    this.detach(PropertyEvent.filter((Listener)new PropagationListener(tail, listener), property));
                    ModelElementList list = this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.detach(listener, tail);
                    }
                } else {
                    this.logInvalidModelPathMessage(path);
                }
            }
        }
    }

    @Override
    public final void detach(Listener listener, ModelProperty property) {
        if (this.disposed()) {
            return;
        }
        this.detach(listener, property.getName());
    }

    protected final void post(Event event) {
        this.listeners.post(event);
    }

    protected final void broadcast() {
        this.listeners.broadcast();
    }

    protected final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    final void broadcastPropertyContentEvent(ModelProperty property) {
        this.broadcast(new PropertyContentEvent(this, property));
    }

    final void broadcastPropertyEnablementEvent(ModelProperty property, boolean before, boolean after) {
        this.broadcast(new PropertyEnablementEvent(this, property, before, after));
    }

    final void broadcastPropertyValidationEvent(ModelProperty property, Status before, Status after) {
        this.broadcast(new PropertyValidationEvent(this, property, before, after));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean disposed() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (!this.disposed) {
                this.disposed = true;
                this.broadcast(new ElementDisposeEvent(this));
                if (this.elementServiceContext != null) {
                    this.elementServiceContext.dispose();
                }
                for (ServiceContext serviceContext : this.propertyServiceContexts.values()) {
                    serviceContext.dispose();
                }
                for (Object object : this.properties.values()) {
                    if (object instanceof ModelElementHandle) {
                        Object element = ((ModelElementHandle)object).element(false);
                        if (element == null) continue;
                        element.dispose();
                        continue;
                    }
                    if (!(object instanceof ModelElementList)) continue;
                    for (Object element : (ModelElementList)object) {
                        element.dispose();
                    }
                }
                try {
                    this.resource().dispose();
                }
                catch (Exception exception) {
                    LoggingService.log(exception);
                }
            }
        }
    }

    protected final void assertNotDisposed() {
        if (this.disposed()) {
            String msg = NLS.bind(Resources.elementAlreadyDisposed, this.type.getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    private void logInvalidModelPathMessage(ModelPath path) {
        String message = NLS.bind(Resources.invalidModelPath, this.type.getModelElementClass().getName(), path.toString());
        LoggingService.log(Status.createErrorStatus(message));
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        this.assertNotDisposed();
        A result = null;
        for (AdapterService service : this.services(AdapterService.class)) {
            result = service.adapt(adapterType);
            if (result != null) break;
        }
        if (result == null) {
            result = super.adapt(adapterType);
        }
        return result;
    }

    protected static final boolean equal(String value1, String value2) {
        String val1 = ModelElement.normalize(value1);
        String val2 = ModelElement.normalize(value2);
        boolean valuesAreEqual = false;
        if (val1 == val2) {
            valuesAreEqual = true;
        } else if (val1 != null && val2 != null) {
            valuesAreEqual = val1.equals(val2);
        }
        return valuesAreEqual;
    }

    protected static final String normalize(String value) {
        if (value != null && value.equals("")) {
            return null;
        }
        return value;
    }

    private final class PropagationListener
    extends Listener {
        private final ModelPath path;
        private final Listener listener;

        public PropagationListener(ModelPath path, Listener listener) {
            this.path = path;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.path.equals(pl.path) && this.listener.equals(pl.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() ^ this.listener.hashCode();
        }

        public void handle(Event event) {
            if (event instanceof PropertyContentEvent) {
                ModelProperty property = ((PropertyContentEvent)event).property();
                if (property instanceof ListProperty) {
                    ModelElementList list = ModelElement.this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.attach(this.listener, this.path);
                    }
                    this.listener.handle(event);
                } else if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                    Object element = ModelElement.this.read((ElementProperty)property).element();
                    if (element != null) {
                        element.attach(this.listener, this.path);
                    }
                    this.listener.handle(event);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyInitializationListener
    extends FilteredListener<PropertyInitializationEvent> {
        private PropertyInitializationListener() {
        }

        @Override
        protected void handleTypedEvent(PropertyInitializationEvent event) {
            DerivedValueService derivedValueService;
            final IModelElement element = event.element();
            final ModelProperty property = event.property();
            final Listener triggerRefreshListener = new Listener(){

                public void handle(Event event) {
                    if (!element.disposed()) {
                        element.refresh(property);
                    }
                }
            };
            final Set<ModelPath> dependencies = element.service(property, DependenciesAggregationService.class).dependencies();
            for (ModelPath dependency : dependencies) {
                element.attach(triggerRefreshListener, dependency);
            }
            for (EnablementService enablementService : element.services(property, EnablementService.class)) {
                enablementService.attach(triggerRefreshListener);
            }
            element.service(property, ValidationAggregationService.class).attach(triggerRefreshListener);
            DefaultValueService defaultValueService = element.service(property, DefaultValueService.class);
            if (defaultValueService != null) {
                defaultValueService.attach(triggerRefreshListener);
            }
            if ((derivedValueService = element.service(property, DerivedValueService.class)) != null) {
                derivedValueService.attach(triggerRefreshListener);
            }
            if (property.hasAnnotation(ClearOnDisable.class)) {
                FilteredListener<PropertyEnablementEvent> clearOnDisableListener = null;
                if (property instanceof ValueProperty) {
                    final ValueProperty prop = (ValueProperty)property;
                    clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                element.write(prop, null);
                            }
                        }
                    };
                } else if (property instanceof ListProperty) {
                    final ListProperty prop = (ListProperty)property;
                    clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                element.read(prop).clear();
                            }
                        }
                    };
                } else if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                    final ElementProperty prop = (ElementProperty)property;
                    clearOnDisableListener = new FilteredListener<PropertyEnablementEvent>(){

                        @Override
                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            if (event.before() && !event.after()) {
                                element.read(prop).remove();
                            }
                        }
                    };
                }
                if (clearOnDisableListener != null) {
                    element.attach((Listener)clearOnDisableListener, property);
                }
            }
            if (!dependencies.isEmpty()) {
                FilteredListener<ElementDisposeEvent> disposeListener = new FilteredListener<ElementDisposeEvent>(){

                    @Override
                    protected void handleTypedEvent(ElementDisposeEvent event) {
                        for (ModelPath dependency : dependencies) {
                            element.detach(triggerRefreshListener, dependency);
                        }
                    }
                };
                element.attach(disposeListener);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidModelPath;
        public static String cannotWriteProperty;
        public static String elementAlreadyDisposed;

        static {
            Resources.initializeMessages(ModelElement.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

