/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelBasedPossibleValuesService
extends PossibleValuesService {
    private final ModelPath path;
    private Set<String> values;
    private boolean initialized;
    private boolean readPriorToInit;

    public ModelBasedPossibleValuesService(ModelPath path, String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive) {
        super(invalidValueMessageTemplate, invalidValueSeverity, caseSensitive);
        this.path = path;
        this.values = Collections.emptySet();
    }

    @Override
    protected void init() {
        super.init();
        final IModelElement element = this.context(IModelElement.class);
        final FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                ModelBasedPossibleValuesService.this.refresh();
            }
        };
        element.attach((Listener)listener, this.path);
        this.refresh();
        element.attach(new FilteredListener<ElementDisposeEvent>(){

            @Override
            protected void handleTypedEvent(ElementDisposeEvent event) {
                element.detach(listener, ModelBasedPossibleValuesService.this.path);
            }
        });
        this.initialized = true;
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        if (!this.initialized) {
            this.readPriorToInit = true;
        }
        values.addAll(this.values);
    }

    private void refresh() {
        SortedSet<String> newValues;
        IModelElement element = this.context(IModelElement.class);
        if (!element.disposed() && !this.values.equals(newValues = this.context(IModelElement.class).read(this.path))) {
            this.values = Collections.unmodifiableSet(newValues);
            if (this.initialized || this.readPriorToInit) {
                this.broadcast();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(PossibleValues.class) && property.getAnnotation(PossibleValues.class).property().length() > 0;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            PossibleValues a = context.find(ValueProperty.class).getAnnotation(PossibleValues.class);
            return new ModelBasedPossibleValuesService(new ModelPath(a.property()), a.invalidValueMessage(), a.invalidValueSeverity(), a.caseSensitive());
        }
    }
}

