/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.sdk.CreateNormalizedXmlSchemaOp;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.w3c.dom.Element;

public final class CreateNormalizedXmlSchemaOpMethods {
    public static Status execute(CreateNormalizedXmlSchemaOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 2);
        try {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IFile sourceSchemaFile = wsroot.getFile(PathBridge.create((Path)((Path)operation.getSourceFile().getContent())));
            IFile targetSchemaFile = operation.getFileHandle();
            try {
                InputStream sourceSchemaFileInputStream = sourceSchemaFile.getContents();
                try {
                    targetSchemaFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    CreateNormalizedXmlSchemaOpMethods.create(targetSchemaFile.getParent());
                    if (targetSchemaFile.exists()) {
                        targetSchemaFile.setContents(sourceSchemaFileInputStream, 1, null);
                    } else {
                        targetSchemaFile.create(sourceSchemaFileInputStream, 1, null);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        sourceSchemaFileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    sourceSchemaFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            monitor.worked(1);
            try {
                WorkspaceFileResourceStore fileResourceStore = new WorkspaceFileResourceStore(targetSchemaFile);
                XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)fileResourceStore);
                XmlElement root = new XmlElement(xmlResourceStore, xmlResourceStore.getDomDocument().getDocumentElement());
                CreateNormalizedXmlSchemaOpMethods.removeAnnotations(root);
                CreateNormalizedXmlSchemaOpMethods.sort(root);
                root.format();
                xmlResourceStore.save();
            }
            catch (ResourceStoreException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static void create(IContainer container) throws CoreException {
        if (!container.exists()) {
            CreateNormalizedXmlSchemaOpMethods.create(container.getParent());
            IFolder iFolder = (IFolder)container;
            iFolder.create(true, true, null);
        }
    }

    private static void removeAnnotations(XmlElement element) {
        for (XmlElement x : element.getChildElements("annotation")) {
            x.remove();
        }
        for (XmlElement x : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.removeAnnotations(x);
        }
    }

    private static void sort(XmlElement root) {
        ArrayList<XmlElement> elements = new ArrayList<XmlElement>();
        for (XmlElement x : root.getChildElements()) {
            elements.add(x);
            x.remove();
        }
        Collections.sort(elements, new SchemaElementComparator());
        Element rootDomElement = root.getDomNode();
        for (XmlElement x : elements) {
            rootDomElement.insertBefore(x.getDomNode(), null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)CreateNormalizedXmlSchemaOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SchemaElementComparator
    implements Comparator<XmlElement> {
        private SchemaElementComparator() {
        }

        @Override
        public int compare(XmlElement x, XmlElement y) {
            int result = x.getLocalName().compareTo(y.getLocalName());
            if (result == 0) {
                result = x.getAttributeText("name").compareTo(y.getAttributeText("name"));
            }
            return result;
        }
    }
}

