/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.CompositePart;
import org.eclipse.sapphire.ui.ConditionalPart;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.PartChildrenEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SplitFormBlockPart;
import org.eclipse.sapphire.ui.def.Orientation;
import org.eclipse.sapphire.ui.def.SplitFormBlockDef;
import org.eclipse.sapphire.ui.def.SplitFormDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SplitFormPart
extends FormPart {
    @Override
    protected List<SapphirePart> initChildParts() {
        IModelElement element = this.getLocalModelElement();
        ListFactory partsListFactory = ListFactory.start();
        for (SplitFormBlockDef splitFormBlockDef : this.definition().getBlocks()) {
            partsListFactory.add((Object)SplitFormPart.create(this, element, splitFormBlockDef, this.params));
        }
        return partsListFactory.result();
    }

    @Override
    public SplitFormDef definition() {
        return (SplitFormDef)super.definition();
    }

    public Orientation getOrientation() {
        return (Orientation)((Object)this.definition().getOrientation().getContent());
    }

    public List<SplitFormBlockPart> getChildParts() {
        return super.getChildParts();
    }

    @Override
    public final void render(final SapphireRenderingContext context) {
        SashForm form = new SashForm(context.getComposite(), (this.getOrientation() == Orientation.HORIZONTAL ? 256 : 512) | 0x10000);
        form.setLayoutData((Object)GridLayoutUtil.gdhspan(this.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        context.adapt((Control)form);
        List<SplitFormBlockPart> blockParts = this.getChildParts();
        int blockPartsCount = blockParts.size();
        int[] weights = new int[blockPartsCount];
        int i = 0;
        while (i < blockPartsCount) {
            final SplitFormBlockPart block = blockParts.get(i);
            final Composite blockComposite = new Composite((Composite)form, 0);
            context.adapt((Control)blockComposite);
            final SapphireRenderingContext blockContext = new SapphireRenderingContext(this, context, blockComposite);
            int rightMargin = i < blockPartsCount - 1 && this.getOrientation() == Orientation.HORIZONTAL ? 4 : 0;
            int bottomMargin = i < blockPartsCount - 1 && this.getOrientation() == Orientation.VERTICAL ? 1 : 0;
            int topMargin = i > 0 && this.getOrientation() == Orientation.VERTICAL ? 1 : 0;
            blockComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, rightMargin, topMargin, bottomMargin));
            block.render(blockContext);
            final Listener blockChildPartsListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof PartVisibilityEvent || event instanceof PartChildrenEvent) {
                        SapphirePart part = ((SapphirePart.PartEvent)event).part();
                        if (event instanceof PartChildrenEvent && !(part instanceof CompositePart) && !(part instanceof SplitFormBlockPart)) {
                            SplitFormPart.attachChildPartsListener(part, this);
                        }
                        Control[] controlArray = blockComposite.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control control = controlArray[n2];
                            control.dispose();
                            ++n2;
                        }
                        block.render(blockContext);
                        context.layout();
                    }
                }
            };
            for (SapphirePart sapphirePart : block.getChildParts()) {
                SplitFormPart.attachChildPartsListener(sapphirePart, blockChildPartsListener);
            }
            blockComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SplitFormPart.detachChildPartsListener(block, blockChildPartsListener);
                }
            });
            weights[i] = block.getWeight();
            ++i;
        }
        form.setWeights(weights);
    }

    private static void attachChildPartsListener(SapphirePart part, Listener listener) {
        block3: {
            block2: {
                part.attach(listener);
                if (!(part instanceof FormPart) || part instanceof CompositePart || part instanceof SplitFormBlockPart) break block2;
                for (SapphirePart sapphirePart : ((FormPart)part).getChildParts()) {
                    SplitFormPart.attachChildPartsListener(sapphirePart, listener);
                }
                break block3;
            }
            if (!(part instanceof ConditionalPart)) break block3;
            for (SapphirePart sapphirePart : ((ConditionalPart)part).getCurrentBranchContent()) {
                SplitFormPart.attachChildPartsListener(sapphirePart, listener);
            }
        }
    }

    private static void detachChildPartsListener(SapphirePart part, Listener listener) {
        block3: {
            block2: {
                part.detach(listener);
                if (!(part instanceof FormPart) || part instanceof CompositePart || part instanceof SplitFormBlockPart) break block2;
                for (SapphirePart sapphirePart : ((FormPart)part).getChildParts()) {
                    SplitFormPart.detachChildPartsListener(sapphirePart, listener);
                }
                break block3;
            }
            if (!(part instanceof ConditionalPart)) break block3;
            for (SapphirePart sapphirePart : ((ConditionalPart)part).getCurrentBranchContent()) {
                SplitFormPart.detachChildPartsListener(sapphirePart, listener);
            }
        }
    }
}

