/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEmbeddedConnectionTemplate
extends DiagramConnectionTemplate {
    private DiagramNodeTemplate nodeTemplate;
    private Map<IModelElement, List<DiagramConnectionPart>> diagramConnectionMap;
    private Listener modelElementListener;
    private ModelPath endpointPath;

    public DiagramEmbeddedConnectionTemplate(IDiagramExplicitConnectionBindingDef connBindingDef) {
        super(connBindingDef);
    }

    @Override
    public void init() {
        this.nodeTemplate = (DiagramNodeTemplate)this.getParentPart();
        this.diagramEditor = this.nodeTemplate.getDiagramEditorPart();
        this.modelElement = this.getModelElement();
        this.connectionDef = (IDiagramConnectionDef)super.definition();
        this.diagramConnectionMap = new HashMap<IModelElement, List<DiagramConnectionPart>>();
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        this.propertyName = (String)this.bindingDef.getProperty().getContent();
        this.connListProperty = (ListProperty)nodeProperty.getType().property(this.propertyName);
        this.connPartListener = new DiagramConnectionTemplate.ConnectionPartListener();
        this.templateListeners = new CopyOnWriteArraySet();
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramEmbeddedConnectionTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.modelElementListener = new FilteredListener<ElementDisposeEvent>(){

            protected void handleTypedEvent(ElementDisposeEvent event) {
                DiagramEmbeddedConnectionTemplate.this.handleModelElementDispose(event);
            }
        };
        String endpointPropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element()).getProperty().getContent();
        this.endpointPath = new ModelPath(endpointPropStr);
        ModelElementList srcNodeList = this.modelElement.read(nodeProperty);
        for (IModelElement srcNodeModel : srcNodeList) {
            ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
            if (!(connProp instanceof ListProperty)) continue;
            ListProperty connListProperty = (ListProperty)connProp;
            ModelElementList connList = srcNodeModel.read(connListProperty);
            for (IModelElement endpointModel : connList) {
                this.createNewConnectionPart(endpointModel, srcNodeModel);
            }
            this.addModelListener(srcNodeModel);
        }
    }

    public void refreshConnections(IModelElement srcNodeModel) {
        ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
        this.handleConnectionListChange(srcNodeModel, (ListProperty)connProp);
    }

    @Override
    public boolean canStartNewConnection(DiagramNodePart srcNode) {
        ModelElementType desiredsrcNodeType;
        IModelElement srcNodeModel = srcNode.getLocalModelElement();
        ModelElementType srcNodeType = srcNodeModel.type();
        return srcNodeType.equals(desiredsrcNodeType = this.nodeTemplate.getNodeType());
    }

    @Override
    public boolean canCreateNewConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        if (!this.canStartNewConnection(srcNode)) {
            return false;
        }
        IModelElement srcNodeModel = srcNode.getLocalModelElement();
        ModelElementType targetType = targetNode.getLocalModelElement().type();
        ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
        ModelElementType connType = connProp.getType();
        ModelProperty endpointProp = connType.property((String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element()).getProperty().getContent());
        if (endpointProp.getType() == null && endpointProp.hasAnnotation(Reference.class)) {
            return ((Reference)endpointProp.getAnnotation(Reference.class)).target().isAssignableFrom(targetType.getModelElementClass());
        }
        return false;
    }

    @Override
    public void setSerializedEndpoint2(IModelElement connModelElement, String endpoint2Value) {
        IDiagramConnectionEndpointBindingDef endpointDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element();
        String endpointProperty = (String)endpointDef.getProperty().getContent();
        this.setModelProperty(connModelElement, endpointProperty, endpoint2Value);
    }

    @Override
    public DiagramConnectionPart createNewDiagramConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        IModelElement localModelElement;
        ElementProperty elementProperty;
        IModelElement srcNodeModel = srcNode.getLocalModelElement();
        ModelProperty modelProperty = this.nodeTemplate.getModelProperty();
        boolean found = false;
        if (modelProperty instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)modelProperty;
            ModelElementList list = this.modelElement.read(listProperty);
            for (IModelElement listEntryModelElement : list) {
                if (!listEntryModelElement.equals(srcNodeModel)) continue;
                found = true;
                break;
            }
        } else if (modelProperty instanceof ElementProperty && this.modelElement.read(elementProperty = (ElementProperty)modelProperty) != null && (localModelElement = this.modelElement.read(elementProperty).element()) == srcNodeModel) {
            found = true;
        }
        if (!found) {
            throw new RuntimeException("Cannot locate the source node element");
        }
        ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
        IModelElement newEndpoint = null;
        if (connProp instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)connProp;
            ModelElementList list = srcNodeModel.read(listProperty);
            newEndpoint = list.insert();
        }
        String endpointVal = this.getSerializedEndpoint2(targetNode);
        this.setSerializedEndpoint2(newEndpoint, endpointVal);
        DiagramConnectionPart connPart = this.getConnectionPart(srcNodeModel, newEndpoint);
        if (connPart == null) {
            connPart = this.createNewConnectionPart(newEndpoint, srcNodeModel);
        }
        return connPart;
    }

    @Override
    public DiagramConnectionPart createNewConnectionPart(IModelElement connElement, IModelElement srcNodeElement) {
        DiagramEmbeddedConnectionPart connPart = new DiagramEmbeddedConnectionPart(this.bindingDef, srcNodeElement, this.endpointPath);
        connPart.init(this, connElement, this.connectionDef, Collections.<String, String>emptyMap());
        connPart.addListener(this.connPartListener);
        this.addConnectionPart(srcNodeElement, connPart);
        return connPart;
    }

    public void addModelListener(IModelElement srcNodeModel) {
        srcNodeModel.attach(this.modelPropertyListener, this.propertyName);
        srcNodeModel.attach(this.modelElementListener);
    }

    public void removeModelListener(IModelElement srcNodeModel) {
        srcNodeModel.detach(this.modelPropertyListener, this.propertyName);
        srcNodeModel.detach(this.modelElementListener);
    }

    @Override
    public void addModelListener() {
    }

    @Override
    public void removeModelListener() {
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        ModelElementList srcNodeList = this.modelElement.read(nodeProperty);
        for (IModelElement srcNodeModel : srcNodeList) {
            this.removeModelListener(srcNodeModel);
        }
    }

    @Override
    public List<DiagramConnectionPart> getDiagramConnections(IModelElement srcNodeModel) {
        ArrayList<DiagramConnectionPart> allConnParts = new ArrayList<DiagramConnectionPart>();
        if (srcNodeModel != null) {
            if (this.diagramConnectionMap.get(srcNodeModel) != null) {
                allConnParts.addAll((Collection<DiagramConnectionPart>)this.diagramConnectionMap.get(srcNodeModel));
            }
        } else {
            for (List<DiagramConnectionPart> connParts : this.diagramConnectionMap.values()) {
                allConnParts.addAll(connParts);
            }
        }
        return allConnParts;
    }

    @Override
    public void addConnectionPart(IModelElement srcNodeModel, DiagramConnectionPart connPart) {
        List<DiagramConnectionPart> connParts = this.diagramConnectionMap.get(srcNodeModel);
        if (connParts == null) {
            connParts = new ArrayList<DiagramConnectionPart>();
            this.diagramConnectionMap.put(srcNodeModel, connParts);
        }
        connParts.add(connPart);
    }

    @Override
    public void disposeConnectionPart(DiagramConnectionPart connPart) {
        connPart.dispose();
        Collection<List<DiagramConnectionPart>> allConnParts = this.diagramConnectionMap.values();
        for (List<DiagramConnectionPart> connParts : allConnParts) {
            if (!connParts.contains(connPart)) continue;
            connParts.remove(connPart);
            break;
        }
    }

    public void removeConnectionParts(IModelElement srcNodeModel) {
        ArrayList<DiagramConnectionPart> connParts = new ArrayList<DiagramConnectionPart>();
        connParts.addAll(this.getDiagramConnections(srcNodeModel));
        for (DiagramConnectionPart connPart : connParts) {
            this.notifyConnectionDelete(new DiagramConnectionEvent(connPart));
            this.disposeConnectionPart(connPart);
        }
    }

    private void handleModelElementDispose(ElementDisposeEvent event) {
        IModelElement element = event.element();
        List<DiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (DiagramConnectionPart connPart : connParts) {
            if (connPart.getEndpoint1() != element && connPart.getEndpoint2() != element) continue;
            this.notifyConnectionDelete(new DiagramConnectionEvent(connPart));
            this.disposeConnectionPart(connPart);
        }
        this.removeModelListener(element);
    }
}

