/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueSerializationService;

public final class EnumValueImageService
extends ValueImageService {
    private EnumValueType enumType;
    private ValueSerializationService valueSerializationService;
    private final Map<Enum<?>, ImageData> images = new HashMap();

    protected void init() {
        super.init();
        ValueProperty property = this.context(ValueProperty.class);
        this.enumType = new EnumValueType(property.getTypeClass());
        this.valueSerializationService = property.service(ValueSerializationService.class);
    }

    public ImageData provide(String value) {
        Image imageAnnotation;
        Enum item = (Enum)this.valueSerializationService.decode(value);
        if (item == null) {
            return null;
        }
        ImageData image = this.images.get(item);
        if (image == null && (imageAnnotation = this.enumType.getAnnotation(item, Image.class)) != null && (image = ImageData.readFromClassLoader(this.enumType.getEnumTypeClass(), imageAnnotation.path())) != null) {
            this.images.put(item, image);
        }
        return image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Enum.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new EnumValueImageService();
        }
    }
}

