/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import java.io.File;
import java.net.URI;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.ui.SapphireJumpActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class RelativePathJumpActionHandler
extends SapphireJumpActionHandler {
    public static final String ID = "Sapphire.Jump.Path.Relative";

    public RelativePathJumpActionHandler() {
        this.setId(ID);
    }

    protected boolean computeEnablementState() {
        File absoluteFile;
        Path absolutePath;
        ValueProperty property;
        IModelElement element;
        Path relativePath;
        return super.computeEnablementState() && (relativePath = (Path)(element = this.getModelElement()).read(property = this.getProperty()).getContent()) != null && (absolutePath = ((RelativePathService)element.service((ModelProperty)property, RelativePathService.class)).convertToAbsolute(relativePath)) != null && (absoluteFile = absolutePath.toFile()).exists() && absoluteFile.isFile();
    }

    protected Object run(SapphireRenderingContext context) {
        IWorkbenchWindow window;
        File file;
        Path absolutePath;
        ValueProperty property;
        IModelElement element = this.getModelElement();
        Path relativePath = (Path)element.read(property = this.getProperty()).getContent();
        if (relativePath != null && (absolutePath = ((RelativePathService)element.service((ModelProperty)property, RelativePathService.class)).convertToAbsolute(relativePath)) != null && (file = absolutePath.toFile()).exists() && file.isFile() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage page = window.getActivePage();
            IEditorDescriptor editorDescriptor = null;
            try {
                editorDescriptor = IDE.getEditorDescriptor((String)file.getName());
            }
            catch (PartInitException partInitException) {}
            if (editorDescriptor != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)editorDescriptor.getId(), (boolean)true);
                }
                catch (PartInitException e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
        return null;
    }
}

