/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CityPossibleValuesService
extends PossibleValuesService {
    protected void init() {
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                CityPossibleValuesService.this.broadcast();
            }
        };
        Address address = (Address)this.context(Address.class);
        address.attach((Listener)listener, (ModelProperty)Address.PROP_STATE);
        address.attach((Listener)listener, (ModelProperty)Address.PROP_ZIP_CODE);
    }

    protected void fillPossibleValues(SortedSet<String> values) {
        Address address = (Address)this.context(Address.class);
        String state = address.getState().getText();
        String zip = address.getZipCode().getText();
        values.addAll(ZipCodeRepository.getCities(zip, state));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind((String)"\"{0}\" is not a valid city for the specified state and ZIP code.", (Object[])new Object[]{invalidValue});
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

