/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.concurrency.service;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.concurrency.service.TestElement;
import org.eclipse.sapphire.tests.concurrency.service.TestService;

public final class ServiceLookupConcurrencyTest
extends SapphireTestCase {
    private ServiceLookupConcurrencyTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ServiceLookupConcurrencyTest");
        suite.addTest((Test)new ServiceLookupConcurrencyTest("testPropertyServiceLookup"));
        suite.addTest((Test)new ServiceLookupConcurrencyTest("testElementServiceLookup"));
        return suite;
    }

    public void testPropertyServiceLookup() throws Exception {
        final TestElement element = (TestElement)TestElement.TYPE.instantiate();
        Thread t1 = new Thread(){

            public void run() {
                element.services((ModelProperty)TestElement.PROP_VALUE, TestService.class);
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                int i = 0;
                while (i < 1000000) {
                    element.refresh((ModelProperty)TestElement.PROP_VALUE);
                    ++i;
                }
            }
        };
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            if (t1.getState() == Thread.State.BLOCKED && t2.getState() == Thread.State.BLOCKED) {
                ServiceLookupConcurrencyTest.fail((String)"Deadlock!");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void testElementServiceLookup() throws Exception {
        final TestElement element = (TestElement)TestElement.TYPE.instantiate();
        Thread t1 = new Thread(){

            public void run() {
                element.services(TestService.class);
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                TestElement other = (TestElement)TestElement.TYPE.instantiate();
                int i = 0;
                while (i < 1000000) {
                    element.equals(other);
                    ++i;
                }
            }
        };
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            if (t1.getState() == Thread.State.BLOCKED && t2.getState() == Thread.State.BLOCKED) {
                ServiceLookupConcurrencyTest.fail((String)"Deadlock!");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

