/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.localization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.modeling.localization.StandardLocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLocalizationService
extends StandardLocalizationService {
    private final Class<?> cl;

    public ClassLocalizationService(Class<?> cl, Locale locale) {
        super(locale);
        this.cl = cl;
    }

    @Override
    protected boolean load(Locale locale, Map<String, String> keyToText) {
        InputStream stream;
        String path;
        String resPath = path = this.cl.getName().replace('.', '/');
        String localeString = locale.toString();
        if (localeString.length() > 0) {
            resPath = String.valueOf(resPath) + "_" + localeString;
        }
        resPath = String.valueOf(resPath) + ".properties";
        ClassLoader loader = this.cl.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (loader != null && (stream = loader.getResourceAsStream(resPath)) != null) {
            boolean bl;
            try {
                bl = ClassLocalizationService.parse(stream, keyToText);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return bl;
        }
        return false;
    }
}

