/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.internal;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.ui.swt.internal.PossibleValue;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public final class PopUpListFieldPropertyEditorPresentation
extends ValuePropertyEditorRenderer {
    private static final String DATA_DEFAULT_VALUE = "Sapphire.Default.Value";
    private final PopUpListFieldStyle style;
    private Combo combo;

    public PopUpListFieldPropertyEditorPresentation(SapphireRenderingContext context, PropertyEditorPart part, PopUpListFieldStyle style) {
        super(context, part);
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.style = style;
    }

    protected void createContents(Composite parent) {
        PropertyEditorPart part = this.getPart();
        final IModelElement element = part.getLocalModelElement();
        final ValueProperty property = (ValueProperty)part.getProperty();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.getActionPresentationManager());
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Browse"));
        boolean isActionsToolBarNeeded = toolBarActionsPresentation.hasActions();
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(isActionsToolBarNeeded ? 3 : 2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(composite);
        decorator.addEditorControl((Control)composite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        final Combo combo = new Combo(composite, 0x804 | (this.style == PopUpListFieldStyle.STRICT ? 8 : 0));
        combo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        combo.setVisibleItemCount(10);
        decorator.addEditorControl((Control)combo, true);
        this.addControl((Control)combo);
        this.context.adapt((Control)combo);
        this.combo = combo;
        if (isActionsToolBarNeeded) {
            ToolBar toolbar = new ToolBar(composite, 0x800100);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvfill(), 3));
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            this.context.adapt((Control)toolbar);
            decorator.addEditorControl((Control)toolbar);
        }
        final PossibleValuesService possibleValuesService = (PossibleValuesService)element.service((ModelProperty)property, PossibleValuesService.class);
        final ValueNormalizationService valueNormalizationService = (ValueNormalizationService)element.service((ModelProperty)property, ValueNormalizationService.class);
        final MutableReference possibleValuesRef = new MutableReference();
        final MutableReference updatingComboSelection = new MutableReference((Object)false);
        final Runnable updateComboSelectionOp = new Runnable(){

            public void run() {
                Value value = element.read(property);
                String text = valueNormalizationService.normalize(value.getText());
                try {
                    updatingComboSelection.set((Object)true);
                    combo.setData(PopUpListFieldPropertyEditorPresentation.DATA_DEFAULT_VALUE, (Object)value.isDefault());
                    if (text == null) {
                        combo.deselectAll();
                        combo.setText("");
                    } else {
                        List possibleValues = (List)possibleValuesRef.get();
                        int possibleValuesCount = possibleValues.size();
                        int possibleValueIndex = -1;
                        int i = 0;
                        while (i < possibleValuesCount && possibleValueIndex == -1) {
                            if (MiscUtil.equal((Object)((PossibleValue)possibleValues.get(i)).value(), (Object)text)) {
                                possibleValueIndex = i;
                            }
                            ++i;
                        }
                        if (PopUpListFieldPropertyEditorPresentation.this.style == PopUpListFieldStyle.STRICT) {
                            if (possibleValueIndex == -1) {
                                if (possibleValues.size() == combo.getItemCount()) {
                                    combo.add(text);
                                } else {
                                    String existingNonConformingValue = combo.getItem(possibleValuesCount);
                                    if (!existingNonConformingValue.equals(text)) {
                                        combo.setItem(possibleValuesCount, text);
                                    }
                                }
                                possibleValueIndex = possibleValuesCount;
                            } else if (possibleValuesCount < combo.getItemCount()) {
                                combo.remove(possibleValuesCount);
                            }
                        }
                        if (possibleValueIndex != -1) {
                            if (combo.getSelectionIndex() != possibleValueIndex) {
                                combo.setText("");
                                combo.select(possibleValueIndex);
                            }
                        } else if (!MiscUtil.equal((Object)valueNormalizationService.normalize(combo.getText()), (Object)text)) {
                            combo.deselectAll();
                            combo.setText(text);
                        }
                    }
                }
                finally {
                    updatingComboSelection.set((Object)false);
                }
            }
        };
        final Runnable updateComboContentOp = new Runnable(element, property){
            private final PossibleValue.Factory factory;
            {
                this.factory = PossibleValue.factory(iModelElement, valueProperty);
            }

            public void run() {
                List<PossibleValue> possibleValues = this.factory.entries();
                possibleValuesRef.set(possibleValues);
                String[] contentForCombo = new String[possibleValues.size()];
                int i = 0;
                int n = possibleValues.size();
                while (i < n) {
                    contentForCombo[i] = possibleValues.get(i).label();
                    ++i;
                }
                combo.setItems(contentForCombo);
                updateComboSelectionOp.run();
            }
        };
        updateComboContentOp.run();
        final Listener possibleValuesServiceListener = new Listener(){

            public void handle(Event event) {
                updateComboContentOp.run();
            }
        };
        possibleValuesService.attach(possibleValuesServiceListener);
        FilteredListener<PropertyContentEvent> propertyListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                updateComboSelectionOp.run();
            }
        };
        element.attach((Listener)propertyListener, (ModelProperty)property);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                List possible;
                if (((Boolean)updatingComboSelection.get()).booleanValue()) {
                    return;
                }
                String value = null;
                int index = combo.getSelectionIndex();
                if (index != -1 && index < (possible = (List)possibleValuesRef.get()).size()) {
                    value = ((PossibleValue)possible.get(index)).value();
                }
                if (value == null) {
                    value = combo.getText().trim();
                }
                if (value != null) {
                    if (value.length() == 0) {
                        value = null;
                    } else if (((Boolean)combo.getData(PopUpListFieldPropertyEditorPresentation.DATA_DEFAULT_VALUE)).booleanValue() && value.equals(element.read(property).getDefaultText())) {
                        value = null;
                    }
                }
                element.write((ModelProperty)property, (Object)value);
                updateComboSelectionOp.run();
            }
        });
        this.addOnDisposeOperation(new Runnable((Listener)propertyListener, property){
            private final /* synthetic */ Listener val$propertyListener;
            private final /* synthetic */ ValueProperty val$property;
            {
                this.val$propertyListener = listener2;
                this.val$property = valueProperty;
            }

            public void run() {
                possibleValuesService.detach(possibleValuesServiceListener);
                element.detach(this.val$propertyListener, (ModelProperty)this.val$property);
            }
        });
    }

    protected void handleFocusReceivedEvent() {
        this.combo.setFocus();
    }
}

