/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactRepository;
import org.eclipse.sapphire.samples.contacts.PhoneNumber;
import org.eclipse.sapphire.services.ValidationService;

public final class DuplicateContactValidationService
extends ValidationService {
    private Listener listener;

    protected void init() {
        ContactRepository contacts = (ContactRepository)((Contact)this.context(Contact.class)).nearest(ContactRepository.class);
        if (contacts != null) {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    DuplicateContactValidationService.this.broadcast();
                }
            };
            contacts.attach(this.listener, "Contacts/EMail");
            contacts.attach(this.listener, "Contacts/PhoneNumbers/*");
        }
    }

    public Status validate() {
        Contact contact = (Contact)this.context(Contact.class);
        ContactRepository contacts = (ContactRepository)contact.nearest(ContactRepository.class);
        if (contacts != null) {
            String email = (String)contact.getEMail().getContent();
            ModelElementList<PhoneNumber> numbers = contact.getPhoneNumbers();
            if (email != null && !numbers.isEmpty()) {
                for (Contact x : contacts.getContacts()) {
                    if (x == contact || !email.equals(x.getEMail().getContent()) || x.getPhoneNumbers().isEmpty()) continue;
                    for (PhoneNumber cn : numbers) {
                        for (PhoneNumber xn : x.getPhoneNumbers()) {
                            if (!MiscUtil.equal((Object)cn.getAreaCode().getContent(), (Object)xn.getAreaCode().getContent()) || !MiscUtil.equal((Object)cn.getLocalNumber().getContent(), (Object)xn.getLocalNumber().getContent())) continue;
                            String msg = NLS.bind((String)Resources.likelyDuplicate, (Object[])new Object[]{x.getName()});
                            return Status.createWarningStatus((String)msg);
                        }
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        ContactRepository contacts = (ContactRepository)((Contact)this.context(Contact.class)).nearest(ContactRepository.class);
        if (contacts != null) {
            contacts.detach(this.listener, "Contacts/EMail");
            contacts.detach(this.listener, "Contacts/PhoneNumbers/*");
        }
    }

    private static final class Resources
    extends NLS {
        public static String likelyDuplicate;

        static {
            Resources.initializeMessages((String)DuplicateContactValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

