/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.FactsAggregationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireTestCase
extends TestCase {
    private IProject project;

    protected SapphireTestCase(String name) {
        super(name);
    }

    protected final IProject project() throws Exception {
        if (this.project == null) {
            String name = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            this.project.create(null);
            this.project.open(null);
        }
        return this.project;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    protected final InputStream loadResourceAsStream(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        return in;
    }

    protected final String loadResource(String name) throws Exception {
        String string;
        InputStream in = this.loadResourceAsStream(name);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    protected static final void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        SapphireTestCase.assertEquals((String)expected.trim().replace("\r", ""), (String)actual.trim().replace("\r", ""));
    }

    protected static final void assertValidationOk(Value<?> value) {
        SapphireTestCase.assertValidationOk(value.validation());
    }

    protected static final void assertValidationOk(ModelElementHandle<?> handle) {
        SapphireTestCase.assertValidationOk(handle.validation());
    }

    protected static final void assertValidationOk(ModelElementList<?> list) {
        SapphireTestCase.assertValidationOk(list.validation());
    }

    protected static final void assertValidationOk(IModelElement element) {
        SapphireTestCase.assertValidationOk(element.validation());
    }

    protected static final void assertValidationOk(Status status) {
        SapphireTestCase.assertEquals((Object)Status.Severity.OK, (Object)status.severity());
    }

    protected static final void assertValidationWarning(Value<?> value, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(value.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(ModelElementHandle<?> handle, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(handle.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(ModelElementList<?> list, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(list.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(IModelElement element, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(element.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(Status status, String expectedMessage) {
        SapphireTestCase.assertEquals((Object)Status.Severity.WARNING, (Object)status.severity());
        SapphireTestCase.assertEquals((String)expectedMessage, (String)status.message());
    }

    protected static final void assertValidationError(Value<?> value, String expectedMessage) {
        SapphireTestCase.assertValidationError(value.validation(), expectedMessage);
    }

    protected static final void assertValidationError(ModelElementHandle<?> handle, String expectedMessage) {
        SapphireTestCase.assertValidationError(handle.validation(), expectedMessage);
    }

    protected static final void assertValidationError(ModelElementList<?> list, String expectedMessage) {
        SapphireTestCase.assertValidationError(list.validation(), expectedMessage);
    }

    protected static final void assertValidationError(IModelElement element, String expectedMessage) {
        SapphireTestCase.assertValidationError(element.validation(), expectedMessage);
    }

    protected static final void assertValidationError(Status status, String expectedMessage) {
        SapphireTestCase.assertEquals((Object)Status.Severity.ERROR, (Object)status.severity());
        SapphireTestCase.assertEquals((String)expectedMessage, (String)status.message());
    }

    protected static void assertElementValidationEvent(Event event, IModelElement element, Status before, Status after) {
        SapphireTestCase.assertInstanceOf(event, ElementValidationEvent.class);
        ElementValidationEvent evt = (ElementValidationEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertElementDisposeEvent(Event event, IModelElement element) {
        SapphireTestCase.assertInstanceOf(event, ElementDisposeEvent.class);
        ElementDisposeEvent evt = (ElementDisposeEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
    }

    protected static void assertPropertyInitializationEvent(Event event, IModelElement element, ModelProperty property) {
        SapphireTestCase.assertInstanceOf(event, PropertyInitializationEvent.class);
        PropertyInitializationEvent evt = (PropertyInitializationEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
    }

    protected static void assertPropertyContentEvent(Event event, IModelElement element, ModelProperty property) {
        SapphireTestCase.assertInstanceOf(event, PropertyContentEvent.class);
        PropertyContentEvent evt = (PropertyContentEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
    }

    protected static void assertPropertyValidationEvent(Event event, IModelElement element, ModelProperty property, Status before, Status after) {
        SapphireTestCase.assertInstanceOf(event, PropertyValidationEvent.class);
        PropertyValidationEvent evt = (PropertyValidationEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertPropertyEnablementEvent(Event event, IModelElement element, ModelProperty property, boolean before, boolean after) {
        SapphireTestCase.assertInstanceOf(event, PropertyEnablementEvent.class);
        PropertyEnablementEvent evt = (PropertyEnablementEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((boolean)before, (boolean)evt.before());
        SapphireTestCase.assertEquals((boolean)after, (boolean)evt.after());
    }

    protected static void assertFact(IModelElement element, ModelProperty property, String fact) {
        SortedSet facts = ((FactsAggregationService)element.service(property, FactsAggregationService.class)).facts();
        SapphireTestCase.assertTrue((boolean)facts.contains(fact));
    }

    protected static void assertContainsInstanceOf(Collection<?> collection, Class<?> type) {
        boolean found = false;
        for (Object obj : collection) {
            if (!type.isInstance(obj)) continue;
            found = true;
            break;
        }
        if (!found) {
            SapphireTestCase.fail((String)("Collection does not contain instance of " + type.getName() + " type."));
        }
    }

    protected static void assertInstanceOf(Object object, Class<?> type) {
        if (!type.isInstance(object)) {
            SapphireTestCase.fail((String)("Expected " + type.getSimpleName() + ". Found " + object.getClass().getSimpleName() + "."));
        }
    }

    protected static <T> List<T> list(T ... items) {
        return MiscUtil.list((Object[])items);
    }

    protected static <T> Set<T> set(T ... items) {
        return MiscUtil.set((Object[])items);
    }

    protected static <T> T item(Collection<T> collection, int index) {
        if (collection instanceof List) {
            return (T)((List)collection).get(index);
        }
        int size = collection.size();
        if (index >= 0 && index < size) {
            Iterator<T> itr = collection.iterator();
            T item = null;
            int i = 0;
            while (i <= index) {
                item = itr.next();
                ++i;
            }
            return item;
        }
        throw new NoSuchElementException();
    }
}

