/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ContentProposal;
import org.eclipse.sapphire.services.ContentProposalService;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class PossibleValuesContentProposalService
extends ContentProposalService {
    private PossibleValuesService possibleValuesService;

    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ValueProperty property = this.context(ValueProperty.class);
        this.possibleValuesService = element.service(property, PossibleValuesService.class);
        if (this.possibleValuesService == null) {
            throw new IllegalStateException();
        }
    }

    public ContentProposalService.Session session() {
        return new ContentProposalService.Session(this){

            @Override
            protected List<ContentProposal> compute() {
                String filter = this.filter().toLowerCase();
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                if (filter.length() == 0) {
                    for (String value : PossibleValuesContentProposalService.this.possibleValuesService.values()) {
                        ContentProposal proposal = new ContentProposal(value);
                        proposals.add(proposal);
                    }
                } else {
                    for (ContentProposal proposal : this.proposals()) {
                        if (!proposal.content().toLowerCase().startsWith(filter)) continue;
                        proposals.add(proposal);
                    }
                }
                return proposals;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property;
            IModelElement element = context.find(IModelElement.class);
            return element != null && (property = context.find(ValueProperty.class)) != null && element.service(property, PossibleValuesService.class) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new PossibleValuesContentProposalService();
        }
    }
}

