/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.sapphire.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetFactory<E> {
    private Filter<E> filter;
    private E firstElement = null;
    private Set<E> set = null;
    private boolean exported = false;

    private SetFactory() {
    }

    public static <E> Set<E> empty() {
        return Collections.emptySet();
    }

    public static <E> Set<E> singleton(E element) {
        return Collections.singleton(element);
    }

    public static <E> Set<E> unmodifiable(E ... elements) {
        return SetFactory.start().add(elements).result();
    }

    public static <E> Set<E> unmodifiable(Collection<E> elements) {
        return SetFactory.start().add(elements).result();
    }

    public static <E> SetFactory<E> start() {
        return new SetFactory<E>();
    }

    public SetFactory<E> filter(Filter<E> filter) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.filter = filter;
        if (this.filter != null) {
            if (this.set != null) {
                Iterator<E> itr = this.set.iterator();
                while (itr.hasNext()) {
                    if (this.filter.allows(itr.next())) continue;
                    itr.remove();
                }
                int size = this.set.size();
                if (size == 1) {
                    this.firstElement = this.set.iterator().next();
                    this.set = null;
                } else if (size == 0) {
                    this.set = null;
                }
            } else if (this.firstElement != null && !this.filter.allows(this.firstElement)) {
                this.firstElement = null;
            }
        }
        return this;
    }

    public SetFactory<E> add(E element) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (element != null && (this.filter == null || this.filter.allows(element))) {
            if (this.set != null) {
                this.set.add(element);
            } else if (this.firstElement != null) {
                this.set = new HashSet();
                this.set.add(this.firstElement);
                this.set.add(element);
                this.firstElement = null;
            } else {
                this.firstElement = element;
            }
        }
        return this;
    }

    public SetFactory<E> add(E ... elements) {
        if (elements != null) {
            E[] EArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                E element = EArray[n2];
                this.add(element);
                ++n2;
            }
        }
        return this;
    }

    public SetFactory<E> add(Collection<E> elements) {
        if (elements != null) {
            for (E element : elements) {
                this.add(element);
            }
        }
        return this;
    }

    public boolean remove(E element) {
        boolean removed = false;
        if (element != null) {
            if (this.set != null) {
                removed = this.set.remove(element);
                if (this.set.size() == 1) {
                    this.firstElement = this.set.iterator().next();
                    this.set = null;
                }
            } else if (this.firstElement != null && this.firstElement.equals(element)) {
                removed = true;
                this.firstElement = null;
            }
        }
        return removed;
    }

    public boolean contains(E element) {
        boolean contains = false;
        if (this.set != null) {
            contains = this.set.contains(element);
        } else if (this.firstElement != null && this.firstElement.equals(element)) {
            contains = true;
        }
        return contains;
    }

    public int size() {
        int size = this.set != null ? this.set.size() : (this.firstElement != null ? 1 : 0);
        return size;
    }

    public Set<E> result() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.set != null) {
            return Collections.unmodifiableSet(this.set);
        }
        if (this.firstElement != null) {
            return Collections.singleton(this.firstElement);
        }
        return Collections.emptySet();
    }
}

