/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.HashMap;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.CorruptedResourceException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlRootBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlDocumentType;
import org.eclipse.sapphire.modeling.xml.annotations.XmlSchema;
import org.eclipse.sapphire.modeling.xml.annotations.XmlSchemas;
import org.eclipse.sapphire.modeling.xml.internal.DocumentTypeRootElementController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootXmlResource
extends XmlResource {
    private static final String PI_XML_TARGET = "xml";
    private static final String PI_XML_DATA = "version=\"1.0\" encoding=\"UTF-8\"";
    private final XmlResourceStore store;
    private final Document document;
    private RootElementController rootElementController;
    private XmlElement rootXmlElement;

    public RootXmlResource() {
        this(new XmlResourceStore());
    }

    public RootXmlResource(XmlResourceStore store) {
        super(null);
        this.store = store;
        this.document = store.getDomDocument();
    }

    public XmlResourceStore store() {
        return this.store;
    }

    @Override
    public void init(IModelElement modelElement) {
        XmlBinding xmlBindingAnnotation;
        super.init(modelElement);
        ModelElementType modelElementType = modelElement.type();
        CustomXmlRootBinding customXmlRootBindingAnnotation = (CustomXmlRootBinding)modelElementType.getAnnotation(CustomXmlRootBinding.class);
        if (customXmlRootBindingAnnotation != null) {
            try {
                this.rootElementController = customXmlRootBindingAnnotation.value().newInstance();
            }
            catch (Exception e) {
                LoggingService.log((Exception)e);
            }
        }
        if (this.rootElementController == null && (xmlBindingAnnotation = (XmlBinding)modelElementType.getAnnotation(XmlBinding.class)) != null && xmlBindingAnnotation.path().length() != 0) {
            XmlPath path = new XmlPath(xmlBindingAnnotation.path(), this.getXmlNamespaceResolver());
            QName qualifiedName = path.getSegment(0).getQualifiedName();
            String localName = qualifiedName.getLocalPart();
            String prefix = qualifiedName.getPrefix();
            String namespace = qualifiedName.getNamespaceURI();
            XmlDocumentType xmlDocumentTypeAnnotation = (XmlDocumentType)modelElementType.getAnnotation(XmlDocumentType.class);
            if (xmlDocumentTypeAnnotation != null && xmlDocumentTypeAnnotation.systemId().length() != 0) {
                this.rootElementController = new DocumentTypeRootElementController(localName);
            } else {
                XmlSchema xmlSchemaAnnotation;
                HashMap<String, String> schemas = new HashMap<String, String>();
                XmlSchemas xmlSchemasAnnotation = (XmlSchemas)modelElementType.getAnnotation(XmlSchemas.class);
                if (xmlSchemasAnnotation != null) {
                    XmlSchema[] xmlSchemaArray = xmlSchemasAnnotation.value();
                    int n = xmlSchemaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        xmlSchemaAnnotation = xmlSchemaArray[n2];
                        String xmlSchemaNamespace = xmlSchemaAnnotation.namespace().trim();
                        String xmlSchemaLocation = xmlSchemaAnnotation.location().trim();
                        if (xmlSchemaNamespace.length() != 0 && xmlSchemaLocation.length() != 0) {
                            schemas.put(xmlSchemaNamespace, xmlSchemaLocation);
                        }
                        ++n2;
                    }
                }
                if ((xmlSchemaAnnotation = (XmlSchema)modelElementType.getAnnotation(XmlSchema.class)) != null) {
                    String xmlSchemaNamespace = xmlSchemaAnnotation.namespace().trim();
                    String xmlSchemaLocation = xmlSchemaAnnotation.location().trim();
                    if (xmlSchemaNamespace.length() != 0 && xmlSchemaLocation.length() != 0) {
                        schemas.put(xmlSchemaNamespace, xmlSchemaLocation);
                    }
                }
                this.rootElementController = new StandardRootElementController(namespace, prefix, localName, schemas);
            }
        }
        if (this.rootElementController == null) {
            this.rootElementController = new StandardRootElementController(XmlUtil.createDefaultElementName(modelElementType));
        }
        this.rootElementController.init(this);
        this.store().registerRootModelElement(modelElement);
    }

    public final Document getDomDocument() {
        return this.document;
    }

    @Override
    public XmlElement getXmlElement(boolean createIfNecessary) {
        Element root = this.document.getDocumentElement();
        if (this.document.getChildNodes().getLength() == 0) {
            if (createIfNecessary) {
                this.fixMalformedDescriptor();
                root = this.document.getDocumentElement();
            }
        } else {
            boolean isRootValid;
            boolean bl = isRootValid = root == null ? false : this.rootElementController.checkRootElement();
            if (!isRootValid) {
                root = null;
                if (createIfNecessary) {
                    if (this.validateCorruptedResourceRecovery()) {
                        this.fixMalformedDescriptor();
                        root = this.document.getDocumentElement();
                    } else {
                        throw new CorruptedResourceException();
                    }
                }
            }
        }
        if (root == null) {
            this.rootXmlElement = null;
        } else if (this.rootXmlElement == null || root != this.rootXmlElement.getDomNode()) {
            this.rootXmlElement = new XmlElement(this.store(), root);
        }
        return this.rootXmlElement;
    }

    public void save() throws ResourceStoreException {
        if (this.document.getChildNodes().getLength() == 0) {
            this.fixMalformedDescriptor();
        }
        this.store.save();
    }

    public <A> A adapt(Class<A> adapterType) {
        Object adapter = this.store.adapt(adapterType);
        if (adapter == null) {
            adapter = super.adapt(adapterType);
        }
        return adapter;
    }

    public boolean isOutOfDate() {
        return this.store.isOutOfDate();
    }

    public void dispose() {
        super.dispose();
        this.store.dispose();
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return this.store.getLocalizationService(locale);
    }

    private final void fixMalformedDescriptor() {
        NodeList topLevelNodes = this.document.getChildNodes();
        Node[] nodes = new Node[topLevelNodes.getLength()];
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            nodes[i] = topLevelNodes.item(i);
            ++i;
        }
        Node[] nodeArray = nodes;
        int n2 = nodes.length;
        n = 0;
        while (n < n2) {
            Node node = nodeArray[n];
            this.document.removeChild(node);
            ++n;
        }
        if (this.store().isXmlDeclarationNeeded()) {
            ProcessingInstruction xmlDeclarationNode = this.document.createProcessingInstruction(PI_XML_TARGET, PI_XML_DATA);
            this.document.insertBefore(xmlDeclarationNode, null);
            Text newLineTextNode = this.document.createTextNode("\n");
            this.document.insertBefore(newLineTextNode, null);
        }
        this.rootElementController.createRootElement();
    }
}

