/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Service {
    private boolean initialized;
    private ServiceContext context;
    private Map<String, String> params;
    private final ListenerContext listeners = new ListenerContext();

    final void init(ServiceContext context, Map<String, String> params) {
        this.context = context;
        int paramsCount = params.size();
        if (paramsCount == 0) {
            this.params = Collections.emptyMap();
        } else if (paramsCount == 1) {
            Map.Entry<String, String> entry = params.entrySet().iterator().next();
            this.params = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else {
            this.params = new HashMap<String, String>(params);
            this.params = Collections.unmodifiableMap(this.params);
        }
    }

    final void initIfNecessary() {
        if (!this.initialized) {
            this.initialized = true;
            try {
                this.init();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    protected void init() {
    }

    public final ServiceContext context() {
        return this.context;
    }

    public final <T> T context(Class<T> type) {
        return this.context.find(type);
    }

    protected final <S extends Service> S service(Class<S> serviceType) {
        return this.context.service(serviceType);
    }

    protected final <S extends Service> List<S> services(Class<S> serviceType) {
        return this.context.services(serviceType);
    }

    protected final Map<String, String> params() {
        return this.params;
    }

    protected final String param(String name) {
        return this.params.get(name);
    }

    final void coordinate(ListenerContext context) {
        this.listeners.coordinate(context);
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    protected final void broadcast(ServiceEvent event) {
        this.listeners.broadcast(event);
    }

    protected final void broadcast() {
        this.broadcast(new ServiceEvent(this));
    }

    public void dispose() {
    }
}

