/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class PossibleValuesValidationService
extends ValidationService {
    private PossibleValuesService possibleValuesService;
    private Listener possibleValuesServiceListener;

    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ValueProperty property = this.context(ValueProperty.class);
        this.possibleValuesService = element.service(property, PossibleValuesService.class);
        if (this.possibleValuesService != null) {
            this.possibleValuesServiceListener = new Listener(){

                public void handle(Event event) {
                    PossibleValuesValidationService.this.broadcast();
                }
            };
            this.possibleValuesService.attach(this.possibleValuesServiceListener);
        }
    }

    public Status validate() {
        Status.Severity severity;
        ValueProperty property;
        IModelElement element = this.context(IModelElement.class);
        Value value = element.read(property = this.context(ValueProperty.class));
        String valueString = value.getText(true);
        if (valueString != null && this.possibleValuesService != null && !this.possibleValuesService.values().contains(valueString) && (severity = this.possibleValuesService.getInvalidValueSeverity(valueString)) != Status.Severity.OK) {
            String message = this.possibleValuesService.getInvalidValueMessage(valueString);
            return Status.createStatus(severity, message);
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        super.dispose();
        if (this.possibleValuesServiceListener != null) {
            this.possibleValuesService.detach(this.possibleValuesServiceListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            IModelElement element;
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && (element = context.find(IModelElement.class)).service(property, PossibleValuesService.class) != null && element.service(property, ReferenceService.class) == null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new PossibleValuesValidationService();
        }
    }
}

