/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class FactsAssistContributor
extends PropertyEditorAssistContributor {
    public FactsAssistContributor() {
        this.setId("System.FactsContributor");
        this.setPriority(110);
    }

    public void contribute(PropertyEditorAssistContext context) {
        IModelElement element = context.getModelElement();
        ModelProperty property = context.getProperty();
        boolean contribute = false;
        if (!element.validation(property).ok()) {
            contribute = true;
        } else if (property instanceof ValueProperty) {
            if (element.read((ValueProperty)property).getText(false) != null) {
                contribute = true;
            }
        } else if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
            if (element.read((ElementProperty)property).element() != null) {
                contribute = true;
            }
        } else if (property instanceof ListProperty && element.read((ListProperty)property).size() > 0) {
            contribute = true;
        }
        if (contribute) {
            for (String fact : ((FactsAggregationService)element.service(property, FactsAggregationService.class)).facts()) {
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p>" + FactsAssistContributor.escapeForXml(fact) + "</p>");
                PropertyEditorAssistSection section = context.getSection("info");
                section.addContribution(contribution.create());
            }
        }
    }
}

