/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.ConditionalPart;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireEnumControlledPageBook;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireWithDirective;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RestoreDefaultsActionHandler
extends SapphireActionHandler {
    public static final String ID = "Sapphire.Restore.Defaults";

    public RestoreDefaultsActionHandler() {
        this.setId(ID);
    }

    @Override
    protected Object run(SapphireRenderingContext context) {
        SapphirePart part = (SapphirePart)this.getPart();
        LinkedHashSet<PropertyRef> properties = new LinkedHashSet<PropertyRef>();
        RestoreDefaultsActionHandler.collectProperties(part, properties);
        Iterator itr = properties.iterator();
        while (itr.hasNext()) {
            PropertyRef pref = (PropertyRef)itr.next();
            if (pref.property instanceof ValueProperty) {
                Value value = pref.modelElement.read((ValueProperty)pref.property);
                if (!value.isDefault()) continue;
                itr.remove();
                continue;
            }
            if (pref.property instanceof ListProperty) {
                ModelElementList list = pref.modelElement.read((ListProperty)pref.property);
                if (!list.isEmpty()) continue;
                itr.remove();
                continue;
            }
            ModelElementHandle child = pref.modelElement.read((ElementProperty)pref.property);
            if (child.removable() && child.element() != null) continue;
            itr.remove();
        }
        if (properties.isEmpty()) {
            MessageDialog.openInformation((Shell)context.getShell(), (String)Resources.dialogTitle, (String)Resources.nothingToDoMessage);
        } else {
            Set selectedProperties = PromptDialog.open(context.getShell(), properties);
            for (PropertyRef pref : selectedProperties) {
                if (pref.property instanceof ValueProperty) {
                    pref.modelElement.write(pref.property, null);
                    continue;
                }
                if (pref.property instanceof ListProperty) {
                    ModelElementList list = pref.modelElement.read((ListProperty)pref.property);
                    for (IModelElement item : list) {
                        list.remove((Object)item);
                    }
                    continue;
                }
                if (!(pref.property instanceof ElementProperty)) continue;
                ModelElementHandle handle = pref.modelElement.read((ElementProperty)pref.property);
                handle.remove();
            }
        }
        return null;
    }

    public static void collectProperties(SapphirePart part, Set<PropertyRef> result) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        if (!part.visible()) break block6;
                        if (!(part instanceof FormPart)) break block7;
                        for (SapphirePart sapphirePart : ((FormPart)part).getChildParts()) {
                            RestoreDefaultsActionHandler.collectProperties(sapphirePart, result);
                        }
                        break block6;
                    }
                    if (!(part instanceof SapphireWithDirective)) break block8;
                    SapphireWithDirective sapphireWithDirective = (SapphireWithDirective)part;
                    result.add(new PropertyRef(sapphireWithDirective.getLocalModelElement(), (ModelProperty)sapphireWithDirective.getProperty()));
                    break block6;
                }
                if (!(part instanceof SapphireEnumControlledPageBook)) break block9;
                FormPart formPart = ((SapphireEnumControlledPageBook)part).getCurrentPage();
                if (formPart == null) break block6;
                RestoreDefaultsActionHandler.collectProperties(formPart, result);
                break block6;
            }
            if (part instanceof PropertyEditorPart) {
                PropertyEditorPart propertyEditorPart = (PropertyEditorPart)part;
                result.add(new PropertyRef(propertyEditorPart.getLocalModelElement(), propertyEditorPart.getProperty()));
                for (SapphirePart related : propertyEditorPart.getRelatedContent()) {
                    RestoreDefaultsActionHandler.collectProperties(related, result);
                }
            } else if (part instanceof ConditionalPart) {
                ConditionalPart conditionalPart = (ConditionalPart)part;
                for (SapphirePart child : conditionalPart.getCurrentBranchContent()) {
                    RestoreDefaultsActionHandler.collectProperties(child, result);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromptDialog
    extends Dialog {
        private final Set<PropertyRef> allProperties;
        private final Set<PropertyRef> selectedProperties;

        private static Set<PropertyRef> open(Shell shell, Set<PropertyRef> properties) {
            PromptDialog dialog = new PromptDialog(shell, properties);
            if (dialog.open() == 0) {
                return dialog.selectedProperties;
            }
            return Collections.emptySet();
        }

        private PromptDialog(Shell shell, Set<PropertyRef> properties) {
            super(shell);
            this.allProperties = properties;
            this.selectedProperties = new HashSet<PropertyRef>(this.allProperties);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Resources.dialogTitle);
            Composite composite = (Composite)super.createDialogArea(parent);
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(Resources.dialogMessage);
            messageLabel.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 300));
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            Table table = tableViewer.getTable();
            table.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 300), 300));
            tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return PromptDialog.this.allProperties.toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public String getColumnText(Object element, int columnIndex) {
                    ModelProperty property = ((PropertyRef)element).property;
                    return property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }
            });
            tableViewer.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return PromptDialog.this.selectedProperties.contains(element);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            tableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    PropertyRef property = (PropertyRef)event.getElement();
                    if (event.getChecked()) {
                        PromptDialog.this.selectedProperties.add(property);
                    } else {
                        PromptDialog.this.selectedProperties.remove(property);
                    }
                }
            });
            tableViewer.setInput((Object)this);
            return composite;
        }
    }

    public static final class PropertyRef {
        public final IModelElement modelElement;
        public final ModelProperty property;

        public PropertyRef(IModelElement modelElement, ModelProperty property) {
            this.modelElement = modelElement;
            this.property = property;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropertyRef) {
                PropertyRef ref = (PropertyRef)obj;
                return this.modelElement == ref.modelElement && this.property == ref.property;
            }
            return false;
        }

        public int hashCode() {
            return this.modelElement.hashCode() ^ this.property.hashCode();
        }
    }

    private static final class Resources
    extends NLS {
        public static String dialogTitle;
        public static String dialogMessage;
        public static String nothingToDoMessage;

        static {
            Resources.initializeMessages((String)RestoreDefaultsActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

