/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zipcodes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.samples.internal.SapphireSamplesPlugin;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRecord;
import org.eclipse.sapphire.util.StringUtil;
import org.osgi.framework.Bundle;

public final class ZipCodeRepository {
    private static boolean initialized = false;
    private static Map<IndexKey, List<ZipCodeRecord>> index = new HashMap<IndexKey, List<ZipCodeRecord>>();

    public static SortedSet<String> getZipCodes(String stateCode, String city) {
        TreeSet<String> result = new TreeSet<String>();
        for (ZipCodeRecord record : ZipCodeRepository.find(null, stateCode, city)) {
            result.add(record.getZipCode());
        }
        return result;
    }

    public static SortedSet<String> getStateCodes(String zipCode, String city) {
        TreeSet<String> result = new TreeSet<String>();
        for (ZipCodeRecord record : ZipCodeRepository.find(zipCode, null, city)) {
            result.add(record.getStateCode());
        }
        return result;
    }

    public static SortedSet<String> getCities(String zipCode, String stateCode) {
        TreeSet<String> result = new TreeSet<String>();
        for (ZipCodeRecord record : ZipCodeRepository.find(zipCode, stateCode, null)) {
            result.add(record.getCity());
        }
        return result;
    }

    public static List<ZipCodeRecord> find(String zipCode, String stateCode, String city) {
        ZipCodeRepository.initialize();
        List<ZipCodeRecord> result = index.get(new IndexKey(zipCode, stateCode, city));
        result = result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
        return result;
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        URL zipCodesRepositoryUrl = FileLocator.find((Bundle)SapphireSamplesPlugin.getBundle(), (IPath)new Path("zipcodes/zipcodes.txt"), null);
        try {
            InputStream in = zipCodesRepositoryUrl.openStream();
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(in, StringUtil.UTF8));
                String line = r.readLine();
                while (line != null) {
                    String[] segments = line.split("\\|\\|");
                    if (segments.length == 6) {
                        String zipCode = segments[0];
                        String stateCode = segments[3];
                        String city = segments[4];
                        String county = segments[5];
                        ZipCodeRecord record = new ZipCodeRecord(zipCode, stateCode, county, city);
                        ZipCodeRepository.addToIndex(new IndexKey(null, null, null), record);
                        ZipCodeRepository.addToIndex(new IndexKey(record.getZipCode(), null, null), record);
                        ZipCodeRepository.addToIndex(new IndexKey(null, record.getStateCode(), null), record);
                        ZipCodeRepository.addToIndex(new IndexKey(null, null, record.getCity()), record);
                        ZipCodeRepository.addToIndex(new IndexKey(record.getZipCode(), record.getStateCode(), null), record);
                        ZipCodeRepository.addToIndex(new IndexKey(record.getZipCode(), null, record.getCity()), record);
                        ZipCodeRepository.addToIndex(new IndexKey(null, record.getStateCode(), record.getCity()), record);
                    }
                    line = r.readLine();
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            SapphireSamplesPlugin.log(e);
        }
        initialized = true;
    }

    private static void addToIndex(IndexKey indexKey, ZipCodeRecord record) {
        List<ZipCodeRecord> list = index.get(indexKey);
        if (list == null) {
            list = new ArrayList<ZipCodeRecord>();
            index.put(indexKey, list);
        }
        list.add(record);
    }

    private static final class IndexKey {
        private final String zip;
        private final String state;
        private final String city;

        public IndexKey(String zip, String state, String city) {
            this.zip = zip;
            this.state = state;
            this.city = city;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexKey)) {
                return false;
            }
            IndexKey k = (IndexKey)obj;
            return IndexKey.equal(this.zip, k.zip) && IndexKey.equal(this.state, k.state) && IndexKey.equal(this.city, k.city);
        }

        public int hashCode() {
            int hashCode = this.zip != null ? this.zip.toLowerCase().hashCode() : 1;
            hashCode *= this.state != null ? this.state.toLowerCase().hashCode() : 1;
            return hashCode *= this.city != null ? this.city.toLowerCase().hashCode() : 1;
        }

        private static boolean equal(String obj1, String obj2) {
            boolean objectsAreEqual = false;
            if (obj1 == obj2) {
                objectsAreEqual = true;
            } else if (obj1 != null && obj2 != null) {
                objectsAreEqual = obj1.equalsIgnoreCase(obj2);
            }
            return objectsAreEqual;
        }
    }
}

