/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.sapphire.ui.diagram.editor.ContainerShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.internal.DirectEditorManagerFactory;
import org.eclipse.sapphire.ui.swt.gef.model.ContainerShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModelUtil;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeCellEditorLocator;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeUtil;
import org.eclipse.sapphire.ui.swt.gef.policies.ShapeLabelDirectEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.tools.SapphireDragEditPartsTracker;

public class ContainerShapeEditPart
extends ShapeEditPart {
    public ContainerShapeEditPart(DiagramConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    protected void createEditPolicies() {
        ContainerShapeModel model = this.getCastedModel();
        ContainerShapePart containerPart = (ContainerShapePart)model.getSapphirePart();
        if (containerPart.isEditable()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ShapeLabelDirectEditPolicy());
        }
    }

    @Override
    public boolean isSelectable() {
        ContainerShapeModel model = this.getCastedModel();
        return model.getShapePresentation().part().isActive();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (child == null) {
            return;
        }
        ShapeModel shapeModel = (ShapeModel)childEditPart.getModel();
        ShapePresentation shapePresentation = shapeModel.getShapePresentation();
        ContainerShapePresentation parentPresentation = this.getParentContainer(shapePresentation);
        IFigure parentFigure = parentPresentation.getFigure();
        Object layoutConstraint = ShapeUtil.getLayoutConstraint(shapePresentation, parentPresentation.getLayout());
        int offset = ShapeUtil.getPresentationCount(parentPresentation, shapePresentation);
        parentFigure.add(child, layoutConstraint, index + offset);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (child == null) {
            return;
        }
        ShapeModel shapeModel = (ShapeModel)childEditPart.getModel();
        ContainerShapePresentation parentPresentation = this.getParentContainer(shapeModel.getShapePresentation());
        IFigure parentFigure = parentPresentation.getFigure();
        parentFigure.remove(child);
    }

    protected List<ShapeModel> getModelChildren() {
        ArrayList<ShapeModel> returnedModelChildren = new ArrayList<ShapeModel>();
        ContainerShapeModel containerModel = this.getCastedModel();
        returnedModelChildren.addAll(ShapeModelUtil.collectActiveChildrenRecursively(containerModel));
        return returnedModelChildren;
    }

    public ContainerShapeModel getCastedModel() {
        return (ContainerShapeModel)this.getModel();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (!(request instanceof DirectEditRequest)) {
                this.performDirectEdit();
            }
        } else if (request.getType().equals("open") && request instanceof SelectionRequest) {
            SelectionRequest selRequest = (SelectionRequest)request;
            Point pt = selRequest.getLocation();
            TextPart textPart = this.getTextPart(pt);
            if (textPart != null) {
                this.performDirectEdit(textPart);
            } else {
                ImagePart imagePart = this.getImagePart(pt);
                if (imagePart != null) {
                    this.invokeDoubleTapAction((ShapePart)imagePart);
                }
            }
        } else {
            super.performRequest(request);
        }
    }

    private void performDirectEdit() {
        List<TextPart> textParts = this.getContainedTextParts();
        if (!textParts.isEmpty()) {
            this.performDirectEdit(textParts.get(0));
        }
    }

    private void performDirectEdit(TextPart textPart) {
        TextFigure textFigure;
        if (textPart.isEditable() && (textFigure = (TextFigure)this.getPartFigure((ShapePart)textPart)) != null) {
            DirectEditManager manager = DirectEditorManagerFactory.createDirectEditorManager((GraphicalEditPart)this, textPart, new NodeCellEditorLocator(this.getConfigurationManager(), textFigure), textFigure);
            manager.show();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object obj;
        String prop = evt.getPropertyName();
        if (prop.equals("SHAPE_START_EDITING")) {
            if (evt.getNewValue() instanceof TextPart) {
                this.performDirectEdit((TextPart)evt.getNewValue());
            } else {
                this.performDirectEdit();
            }
        } else if ("SHAPE_VISIBILITY_UPDATES".equals(prop) && (obj = evt.getNewValue()) instanceof ShapePart) {
            ShapePart shapePart = (ShapePart)obj;
            ShapePresentation parentPresentation = this.getCastedModel().getShapePresentation();
            ShapePresentation shapePresentation = ShapeModelUtil.getChildShapePresentation(parentPresentation, shapePart);
            ShapeUtil.updateFigureForShape(shapePresentation, this.getCastedModel().getNodeModel().getDiagramModel().getResourceCache(), this.getConfigurationManager());
            this.refresh();
        }
    }

    @Override
    protected List<TextPart> getContainedTextParts() {
        ContainerShapePart containerPart = (ContainerShapePart)this.getCastedModel().getSapphirePart();
        return ShapePart.getContainedShapeParts((ShapePart)containerPart, TextPart.class);
    }

    @Override
    protected List<ImagePart> getContainedImageParts() {
        ContainerShapePart containerPart = (ContainerShapePart)this.getCastedModel().getSapphirePart();
        return ShapePart.getContainedShapeParts((ShapePart)containerPart, ImagePart.class);
    }

    public DragTracker getDragTracker(Request request) {
        return new SapphireDragEditPartsTracker((EditPart)this);
    }
}

