/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.xml.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SourceEditorService;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEditorResourceStore
extends XmlResourceStore {
    private SapphireEditor sapphireEditor;
    private StructuredTextEditor sourceEditor;
    private Element rootModelElement;
    private final Map<Node, Object> xmlNodeToModelElementsMap;
    private final INodeAdapter xmlNodeListener;
    private final Scrubber scrubber;
    private final XmlSourceEditorService sourceEditorService;

    public XmlEditorResourceStore(SapphireEditor sapphireEditor, StructuredTextEditor sourceEditor) {
        super(null);
        this.sapphireEditor = sapphireEditor;
        this.sourceEditor = sourceEditor;
        this.rootModelElement = null;
        this.xmlNodeToModelElementsMap = new IdentityHashMap<Node, Object>();
        this.scrubber = new Scrubber();
        this.scrubber.start();
        this.sourceEditorService = new XmlSourceEditorService();
        ISourceEditingTextTools sourceEditingTextTools = (ISourceEditingTextTools)this.sourceEditor.getAdapter(ISourceEditingTextTools.class);
        IDOMSourceEditingTextTools domSourceEditingTextTools = (IDOMSourceEditingTextTools)sourceEditingTextTools;
        this.setDomDocument(domSourceEditingTextTools.getDOMDocument());
        this.xmlNodeListener = new INodeAdapter(){

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                if (eventType == 2 && newValue instanceof IDOMNode) {
                    XmlEditorResourceStore.this.attachXmlNodeListener((IDOMNode)newValue);
                }
                DelayedTasksExecutor.schedule((DelayedTasksExecutor.Task)new RefreshElementsTask(XmlEditorResourceStore.this.getModelElements((Node)notifier)));
            }
        };
        this.attachXmlNodeListener();
    }

    public final SapphireEditor getEditor() {
        return this.sapphireEditor;
    }

    public final StructuredTextEditor getXmlEditor() {
        return this.sourceEditor;
    }

    public boolean isXmlDeclarationNeeded() {
        return true;
    }

    public void save() throws ResourceStoreException {
        IFile file;
        IEditorInput input = this.sourceEditor.getEditorInput();
        if (input instanceof FileEditorInput && !(file = ((FileEditorInput)input).getFile()).exists()) {
            return;
        }
        this.validateSave();
        this.sourceEditor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void validateEdit() {
        IFile file;
        IEditorInput input = this.sourceEditor.getEditorInput();
        if (input instanceof FileEditorInput && !(file = ((FileEditorInput)input).getFile()).exists()) {
            IStatus st = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT);
            if (st.getSeverity() == 4) {
                throw new ValidateEditException();
            }
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new ValidateEditException((Exception)((Object)e));
            }
        }
        if (!this.sourceEditor.validateEditorInputState()) {
            throw new ValidateEditException();
        }
    }

    public void validateSave() {
        if (!this.sourceEditor.validateEditorInputState()) {
            throw new ValidateEditException();
        }
    }

    public <A> A adapt(Class<A> adapterType) {
        Object result = null;
        result = adapterType == ITextEditor.class ? (Object)adapterType.cast(this.getXmlEditor()) : (adapterType == SourceEditorService.class ? (Object)adapterType.cast((Object)this.sourceEditorService) : (adapterType == SapphireEditor.class ? adapterType.cast(this.sapphireEditor) : super.adapt(adapterType)));
        return (A)result;
    }

    public void registerRootModelElement(Element rootModelElement) {
        this.rootModelElement = rootModelElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModelElement(Node xmlNode, Element element) {
        Map<Node, Object> map = this.xmlNodeToModelElementsMap;
        synchronized (map) {
            Object object = this.xmlNodeToModelElementsMap.get(xmlNode);
            if (object == null) {
                this.xmlNodeToModelElementsMap.put(xmlNode, element);
            } else if (object instanceof Element) {
                if (object == element) {
                    return;
                }
                this.xmlNodeToModelElementsMap.put(xmlNode, ListFactory.start().add((Object)((Element)object)).add((Object)element).result());
            } else {
                List list = (List)object;
                for (Object obj : list) {
                    if (obj != element) continue;
                    return;
                }
                this.xmlNodeToModelElementsMap.put(xmlNode, ListFactory.start().add((Collection)list).add((Object)element).result());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModelElement(Node xmlNode, Element element) {
        Map<Node, Object> map = this.xmlNodeToModelElementsMap;
        synchronized (map) {
            Object object = this.xmlNodeToModelElementsMap.get(xmlNode);
            if (object != null) {
                if (object instanceof Element) {
                    if (object == element) {
                        this.xmlNodeToModelElementsMap.remove(xmlNode);
                    }
                } else {
                    List originalList = (List)object;
                    ListFactory modifiedListFactory = ListFactory.start();
                    for (Object entry : originalList) {
                        if (entry == element) continue;
                        modifiedListFactory.add((Object)((Element)entry));
                    }
                    int modifiedListSize = modifiedListFactory.size();
                    if (originalList.size() != modifiedListSize) {
                        if (modifiedListSize == 1) {
                            this.xmlNodeToModelElementsMap.put(xmlNode, modifiedListFactory.get(0));
                        } else {
                            this.xmlNodeToModelElementsMap.put(xmlNode, modifiedListFactory.result());
                        }
                    }
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.detachXmlNodeListener();
        this.scrubber.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Element> getModelElements(Node xmlNode) {
        List elements;
        Map<Node, Object> map = this.xmlNodeToModelElementsMap;
        synchronized (map) {
            Node node = xmlNode;
            Object object = this.xmlNodeToModelElementsMap.get(node);
            while (object == null && node != null && !(node instanceof Document)) {
                node = node.getParentNode();
                object = this.xmlNodeToModelElementsMap.get(node);
            }
            elements = object == null ? ListFactory.singleton((Object)this.rootModelElement) : (object instanceof Element ? (node.getParentNode() instanceof Document ? ListFactory.start().add((Object)this.rootModelElement).add((Object)((Element)object)).result() : ListFactory.singleton((Object)((Element)object))) : (node.getParentNode() instanceof Document ? ListFactory.start().add((Object)this.rootModelElement).add((Collection)((List)object)).result() : (List)object));
        }
        return elements;
    }

    private void attachXmlNodeListener() {
        this.attachXmlNodeListener((IDOMNode)this.getDomDocument());
    }

    private void attachXmlNodeListener(IDOMNode node) {
        node.addAdapter(this.xmlNodeListener);
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            this.attachXmlNodeListener((IDOMNode)children.item(i));
            ++i;
        }
    }

    private void detachXmlNodeListener() {
        this.detachXmlNodeListener((IDOMNode)this.getDomDocument());
    }

    private void detachXmlNodeListener(IDOMNode node) {
        node.removeAdapter(this.xmlNodeListener);
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            this.detachXmlNodeListener((IDOMNode)children.item(i));
            ++i;
        }
    }

    private static final class RefreshElementsTask
    extends DelayedTasksExecutor.Task {
        private final List<Element> elements;

        public RefreshElementsTask(List<Element> elements) {
            this.elements = elements;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof RefreshElementsTask) {
                return this.elements.equals(((RefreshElementsTask)((Object)obj)).elements);
            }
            return false;
        }

        public int hashCode() {
            return this.elements.hashCode();
        }

        public void run() {
            for (Element element : this.elements) {
                if (element.disposed()) continue;
                element.refresh();
            }
        }
    }

    private final class Scrubber
    extends Thread {
        private boolean stopRequested = false;

        private Scrubber() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map xmlNodeToModelElementsMap = XmlEditorResourceStore.this.xmlNodeToModelElementsMap;
            while (true) {
                try {
                    Scrubber.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                Object object = this;
                synchronized (object) {
                    if (this.stopRequested) {
                        return;
                    }
                }
                object = xmlNodeToModelElementsMap;
                synchronized (object) {
                    Iterator itr = xmlNodeToModelElementsMap.keySet().iterator();
                    while (itr.hasNext()) {
                        if (((Node)itr.next()).getParentNode() != null) continue;
                        itr.remove();
                    }
                }
            }
        }

        public synchronized void dispose() {
            this.stopRequested = true;
            this.interrupt();
        }
    }

    private final class XmlSourceEditorService
    extends SourceEditorService {
        private XmlSourceEditorService() {
        }

        public boolean find(Element element, PropertyDef property) {
            return element.resource() instanceof XmlResource;
        }

        public void show(Element element, PropertyDef property) {
            List<XmlNode> xmlNodes;
            StructuredTextEditor sourceView = XmlEditorResourceStore.this.getXmlEditor();
            SourceEditorService.Range range = new SourceEditorService.Range();
            if (property != null && !(xmlNodes = this.getXmlNodes(element, property)).isEmpty()) {
                if (property instanceof ValueProperty) {
                    IDOMNode domNode = (IDOMNode)xmlNodes.get(0).getDomNode();
                    if (domNode instanceof IDOMElement) {
                        IDOMElement domElement = (IDOMElement)domNode;
                        if (domElement.hasEndTag()) {
                            range.merge(domElement.getStartEndOffset(), domElement.getEndStartOffset());
                        } else {
                            range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                        }
                    } else if (domNode instanceof IDOMAttr) {
                        IDOMAttr domAttr = (IDOMAttr)domNode;
                        int start = domAttr.getValueRegionStartOffset();
                        range.merge(start + 1, start + domAttr.getValueRegionText().length() - 1);
                    } else {
                        range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                    }
                } else {
                    for (XmlNode xmlNode : xmlNodes) {
                        IDOMNode domNode = (IDOMNode)xmlNode.getDomNode();
                        range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                    }
                }
            }
            if (!range.initialized()) {
                Element modElement = element;
                Resource resource = modElement.resource();
                XmlElement xmlElement = null;
                if (resource != null) {
                    xmlElement = ((XmlResource)resource).getXmlElement();
                }
                while (xmlElement == null && modElement != null) {
                    Property parent = modElement.parent();
                    if (parent == null) {
                        modElement = null;
                        continue;
                    }
                    modElement = parent.element();
                    resource = modElement.resource();
                    if (resource == null) continue;
                    xmlElement = ((XmlResource)resource).getXmlElement();
                }
                if (xmlElement != null) {
                    IDOMNode domNode = (IDOMNode)xmlElement.getDomNode();
                    range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                }
            }
            TextSelection textSelection = range.initialized() ? new TextSelection(range.start(), range.end() - range.start()) : null;
            sourceView.getSelectionProvider().setSelection((ISelection)textSelection);
            XmlEditorResourceStore.this.getEditor().showPage((Object)sourceView);
        }

        private List<XmlNode> getXmlNodes(Element element, PropertyDef property) {
            if (property instanceof ListProperty) {
                ElementList list = element.property((ListProperty)property);
                ArrayList<XmlNode> xmlNodes = new ArrayList<XmlNode>(list.size());
                for (Element entry : list) {
                    XmlElement xmlNode;
                    Resource resource = entry.resource();
                    if (!(resource instanceof XmlResource) || (xmlNode = ((XmlResource)resource).getXmlElement()) == null) continue;
                    xmlNodes.add((XmlNode)xmlNode);
                }
                return xmlNodes;
            }
            if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                XmlElement xmlNode;
                Resource resource;
                Element child = element.property((ElementProperty)property).content();
                if (child != null && (resource = child.resource()) instanceof XmlResource && (xmlNode = ((XmlResource)resource).getXmlElement()) != null) {
                    return Collections.singletonList(xmlNode);
                }
            } else {
                XmlResource r;
                XmlNode xmlNode;
                Resource resource = element.resource();
                if (resource instanceof XmlResource && (xmlNode = ((XmlValueBindingImpl)(r = (XmlResource)resource).binding(element.property(property))).getXmlNode()) != null) {
                    return Collections.singletonList(xmlNode);
                }
            }
            return Collections.emptyList();
        }
    }
}

