/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.ConversionService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;

public final class StringToImageDataConversionService
extends ConversionService<String, ImageData> {
    public StringToImageDataConversionService() {
        super(String.class, ImageData.class);
    }

    public ImageData convert(String string) {
        ISapphireUiDef sdef;
        Element element = (Element)this.context(Element.class);
        Context ctxt = (Context)element.adapt(Context.class);
        InputStream stream = null;
        if (string != null && !string.contains("/") && (sdef = (ISapphireUiDef)element.nearest(ISapphireUiDef.class)) != null) {
            for (IPackageReference p : sdef.getImportedPackages()) {
                String possibleFullPath;
                String pname = (String)p.getName().content();
                if (pname != null && (stream = ctxt.findResource(possibleFullPath = String.valueOf(pname.replace('.', '/')) + "/" + string)) != null) break;
            }
        }
        if (stream == null) {
            stream = ctxt.findResource(string);
        }
        if (stream != null) {
            ImageData imageData;
            try {
                imageData = (ImageData)ImageData.readFromStream((InputStream)stream).optional();
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return imageData;
        }
        return null;
    }
}

