/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEndpointsEvent;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.StandardDiagramConnectionPart;
import org.eclipse.sapphire.util.CollectionsUtil;

public class DiagramConnectionTemplate
extends SapphirePart {
    protected SapphireDiagramEditorPagePart diagramEditor;
    protected IDiagramConnectionDef connectionDef;
    protected IDiagramExplicitConnectionBindingDef bindingDef;
    protected String propertyName;
    private ListProperty modelProperty;
    protected ListProperty connListProperty;
    protected Listener modelPropertyListener;
    protected Listener connPartListener;
    protected Set<DiagramConnectionTemplateListener> templateListeners;
    private ModelPath originalEndpoint2Path;
    private ModelPath endpoint1Path;
    private ModelPath endpoint2Path;
    private ValueProperty endpoint1Property;
    private ValueProperty endpoint2Property;
    private List<StandardDiagramConnectionPart> diagramConnections = new ArrayList<StandardDiagramConnectionPart>();

    public DiagramConnectionTemplate() {
    }

    public DiagramConnectionTemplate(IDiagramExplicitConnectionBindingDef bindingDef) {
        this.bindingDef = bindingDef;
    }

    @Override
    public void init() {
        Element element = this.getModelElement();
        this.diagramEditor = (SapphireDiagramEditorPagePart)this.parent();
        this.connectionDef = (IDiagramConnectionDef)super.definition();
        this.propertyName = (String)this.bindingDef.getProperty().content();
        this.modelProperty = (ListProperty)element.property(this.propertyName).definition();
        this.initConnPartListener();
        this.templateListeners = new CopyOnWriteArraySet<DiagramConnectionTemplateListener>();
        String endpt1PropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().content()).getProperty().content();
        String endpt2PropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().content()).getProperty().content();
        this.originalEndpoint2Path = new ModelPath(endpt2PropStr);
        ElementType type = this.modelProperty.getType();
        this.endpoint1Property = (ValueProperty)type.property(endpt1PropStr);
        this.endpoint2Property = (ValueProperty)type.property(this.originalEndpoint2Path);
        if (this.getConnectionType() == ConnectionType.OneToOne) {
            this.endpoint1Path = new ModelPath(endpt1PropStr);
            this.endpoint2Path = new ModelPath(endpt2PropStr);
            this.connListProperty = this.modelProperty;
        } else {
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            PropertyDef prop = type.property(head.getPropertyName());
            if (prop instanceof ListProperty) {
                this.endpoint1Path = new ModelPath("../" + endpt1PropStr);
                this.endpoint2Path = this.originalEndpoint2Path.tail();
                this.connListProperty = (ListProperty)prop;
            } else {
                throw new RuntimeException("Invaid Model Path:" + this.originalEndpoint2Path);
            }
        }
        ElementList list = element.property(this.modelProperty);
        for (Element listEntryModelElement : list) {
            if (this.getConnectionType() == ConnectionType.OneToOne) {
                this.createNewConnectionPart(listEntryModelElement, null);
                continue;
            }
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            PropertyDef connProp = listEntryModelElement.property(head.getPropertyName()).definition();
            if (!(connProp instanceof ListProperty)) {
                throw new RuntimeException("Expecting " + connProp.name() + " to be a list property");
            }
            ElementList connList = listEntryModelElement.property((ListProperty)connProp);
            for (Element connElement : connList) {
                this.createNewConnectionPart(connElement, null);
            }
        }
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramConnectionTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    protected void initConnPartListener() {
        this.connPartListener = new FilteredListener<ConnectionEndpointsEvent>(){

            public void handleTypedEvent(ConnectionEndpointsEvent e) {
                DiagramConnectionTemplate.this.notifyConnectionEndpointUpdate(e);
            }
        };
    }

    public String getConnectionTypeId() {
        return (String)this.connectionDef.getId().content();
    }

    public List<StandardDiagramConnectionPart> getDiagramConnections(Element connListParent) {
        ArrayList<StandardDiagramConnectionPart> connList = new ArrayList<StandardDiagramConnectionPart>();
        if (connListParent == null || this.getConnectionType() == ConnectionType.OneToOne) {
            connList.addAll(this.diagramConnections);
        } else {
            for (StandardDiagramConnectionPart connPart : this.diagramConnections) {
                Element connModel = connPart.getLocalModelElement();
                if (connModel.parent().element() != connListParent) continue;
                connList.add(connPart);
            }
        }
        return connList;
    }

    public Element getConnectionParentElement(Element srcNodeModel) {
        if (this.getConnectionType() == ConnectionType.OneToMany) {
            ElementList list = this.getModelElement().property(this.modelProperty);
            for (Element listEntryModelElement : list) {
                SapphireDiagramEditorPagePart diagramEditorPart;
                DiagramNodePart targetNode;
                Value valObj = listEntryModelElement.property(this.endpoint1Property);
                if (!(valObj instanceof ReferenceValue)) continue;
                ReferenceValue reference = (ReferenceValue)valObj;
                Element model = (Element)reference.resolve();
                if (model == null && reference.text() != null && (targetNode = (diagramEditorPart = this.getDiagramEditor()).getNode(reference.text())) != null) {
                    model = targetNode.getLocalModelElement();
                }
                if (srcNodeModel != model) continue;
                return listEntryModelElement;
            }
        }
        return null;
    }

    public boolean canStartNewConnection(DiagramNodePart srcNode) {
        boolean canStart = false;
        ElementType srcType = srcNode.getModelElement().type();
        if (this.endpoint1Property.getType() == null && this.endpoint1Property.hasAnnotation(Reference.class)) {
            canStart = ((Reference)this.endpoint1Property.getAnnotation(Reference.class)).target().isAssignableFrom(srcType.getModelElementClass());
        }
        return canStart;
    }

    public boolean canCreateNewConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        boolean canCreate = false;
        canCreate = this.canStartNewConnection(srcNode);
        if (!canCreate) {
            return false;
        }
        ElementType targetType = targetNode.getModelElement().type();
        if (this.endpoint2Property.getType() == null && this.endpoint2Property.hasAnnotation(Reference.class)) {
            canCreate = ((Reference)this.endpoint2Property.getAnnotation(Reference.class)).target().isAssignableFrom(targetType.getModelElementClass());
        }
        return canCreate;
    }

    public void addModelListener() {
        this.getModelElement().attach(this.modelPropertyListener, this.propertyName);
        if (this.getConnectionType() == ConnectionType.OneToMany) {
            ElementList list = this.getModelElement().property(this.modelProperty);
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            for (Element listEntryModelElement : list) {
                listEntryModelElement.attach(this.modelPropertyListener, head.getPropertyName());
            }
        }
    }

    public void removeModelListener() {
        this.getModelElement().detach(this.modelPropertyListener, this.propertyName);
        if (this.getConnectionType() == ConnectionType.OneToMany) {
            ElementList list = this.getModelElement().property(this.modelProperty);
            for (Element listEntryModelElement : list) {
                ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
                listEntryModelElement.detach(this.modelPropertyListener, head.getPropertyName());
            }
        }
    }

    public void addTemplateListener(DiagramConnectionTemplateListener listener) {
        this.templateListeners.add(listener);
    }

    public void removeTemplateListener(DiagramConnectionTemplateListener listener) {
        this.templateListeners.remove(listener);
    }

    public SapphireDiagramEditorPagePart getDiagramEditor() {
        return this.diagramEditor;
    }

    public ConnectionType getConnectionType() {
        if (this.originalEndpoint2Path.length() > 1) {
            return ConnectionType.OneToMany;
        }
        return ConnectionType.OneToOne;
    }

    public String getSerializedEndpoint1(DiagramNodePart srcNode) {
        String endpoint1Value = null;
        IDiagramConnectionEndpointBindingDef srcAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().content();
        Value<Function> srcFunc = srcAnchorDef.getValue();
        FunctionResult srcFuncResult = this.getNodeReferenceFunction(srcNode, srcFunc, (LocalizationService)this.bindingDef.adapt(LocalizationService.class));
        if (srcFuncResult != null) {
            endpoint1Value = (String)srcFuncResult.value();
            srcFuncResult.dispose();
        }
        if (endpoint1Value == null || endpoint1Value.length() == 0) {
            endpoint1Value = srcNode.getId();
        }
        return endpoint1Value;
    }

    public String getSerializedEndpoint2(DiagramNodePart targetNode) {
        String endpoint2Value = null;
        IDiagramConnectionEndpointBindingDef targetAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().content();
        Value<Function> targetFunc = targetAnchorDef.getValue();
        FunctionResult targetFuncResult = this.getNodeReferenceFunction(targetNode, targetFunc, (LocalizationService)this.bindingDef.adapt(LocalizationService.class));
        if (targetFuncResult != null) {
            endpoint2Value = (String)targetFuncResult.value();
            targetFuncResult.dispose();
        }
        if (endpoint2Value == null || endpoint2Value.length() == 0) {
            endpoint2Value = targetNode.getId();
        }
        return endpoint2Value;
    }

    private Element getOneToManyConnectionSrcElement(String endpoint1Value) {
        ElementList list = this.getModelElement().property(this.modelProperty);
        Element srcElement = null;
        for (Element element : list) {
            String val = element.property(this.endpoint1Property).text();
            if (val == null || !val.equals(endpoint1Value)) continue;
            srcElement = element;
            break;
        }
        return srcElement;
    }

    public void setSerializedEndpoint1(Element connModelElement, String endpoint1Value) {
        IDiagramConnectionEndpointBindingDef srcAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().content();
        if (this.getConnectionType() == ConnectionType.OneToOne) {
            this.setModelProperty(connModelElement, ((ModelPath.PropertySegment)this.endpoint1Path.head()).getPropertyName(), endpoint1Value);
        } else {
            Element srcElement = this.getOneToManyConnectionSrcElement(endpoint1Value);
            if (srcElement != null) {
                String srcProperty = (String)srcAnchorDef.getProperty().content();
                this.setModelProperty(srcElement, srcProperty, endpoint1Value);
            }
        }
    }

    public void setSerializedEndpoint2(Element connModelElement, String endpoint2Value) {
        this.setModelProperty(connModelElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
    }

    public StandardDiagramConnectionPart createNewDiagramConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        String endpoint1Value = this.getSerializedEndpoint1(srcNode);
        String endpoint2Value = this.getSerializedEndpoint2(targetNode);
        if (endpoint1Value != null && endpoint2Value != null) {
            ModelPath.PropertySegment head;
            PropertyDef connProp;
            if (this.getConnectionType() == ConnectionType.OneToOne) {
                ElementList list = this.getModelElement().property(this.modelProperty);
                Element newElement = list.insert();
                this.setModelProperty(newElement, ((ModelPath.PropertySegment)this.endpoint1Path.head()).getPropertyName(), endpoint1Value);
                this.setModelProperty(newElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
                StandardDiagramConnectionPart newConn = this.getConnectionPart(srcNode.getModelElement(), newElement);
                if (newConn == null) {
                    newConn = this.createNewConnectionPart(newElement, null);
                }
                return newConn;
            }
            Element srcElement = this.getOneToManyConnectionSrcElement(endpoint1Value);
            IDiagramConnectionEndpointBindingDef srcAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().content();
            String srcProperty = (String)srcAnchorDef.getProperty().content();
            if (srcElement == null) {
                ElementList list = this.getModelElement().property(this.modelProperty);
                srcElement = list.insert();
                this.setModelProperty(srcElement, srcProperty, endpoint1Value);
            }
            if (!((connProp = srcElement.property((head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head()).getPropertyName()).definition()) instanceof ListProperty)) {
                throw new RuntimeException("Expecting " + connProp.name() + " to be a list property");
            }
            ElementList connList = srcElement.property((ListProperty)connProp);
            Element newElement = connList.insert();
            this.setModelProperty(newElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
            StandardDiagramConnectionPart newConn = this.getConnectionPart(srcElement, newElement);
            if (newConn == null) {
                newConn = this.createNewConnectionPart(newElement, null);
            }
            return newConn;
        }
        return null;
    }

    protected StandardDiagramConnectionPart createNewConnectionPart(Element connElement, Element srcNodeElement) {
        StandardDiagramConnectionPart connPart = new StandardDiagramConnectionPart(this.bindingDef, this.endpoint1Path, this.endpoint2Path);
        this.addConnectionPart(srcNodeElement, connPart);
        connPart.init(this, connElement, this.connectionDef, Collections.<String, String>emptyMap());
        connPart.initialize();
        connPart.attach(this.connPartListener);
        this.notifyConnectionAddEvent(new ConnectionAddEvent(connPart));
        return connPart;
    }

    public void showAllConnectionParts(DiagramNodeTemplate nodeTemplate) {
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (StandardDiagramConnectionPart connPart : connParts) {
            Element endpt1 = connPart.getEndpoint1();
            Element endpt2 = connPart.getEndpoint2();
            DiagramNodePart nodePart1 = this.diagramEditor.getDiagramNodePart(endpt1);
            if (nodePart1 != null && nodePart1.getDiagramNodeTemplate() == nodeTemplate) {
                this.notifyConnectionAddEvent(new ConnectionAddEvent(connPart));
                continue;
            }
            DiagramNodePart nodePart2 = this.diagramEditor.getDiagramNodePart(endpt2);
            if (nodePart2 == null || nodePart2.getDiagramNodeTemplate() != nodeTemplate) continue;
            this.notifyConnectionAddEvent(new ConnectionAddEvent(connPart));
        }
    }

    public void hideAllConnectionParts(DiagramNodeTemplate nodeTemplate) {
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (StandardDiagramConnectionPart connPart : connParts) {
            Element endpt1 = connPart.getEndpoint1();
            Element endpt2 = connPart.getEndpoint2();
            DiagramNodePart nodePart1 = this.diagramEditor.getDiagramNodePart(endpt1);
            if (nodePart1 != null && nodePart1.getDiagramNodeTemplate() == nodeTemplate) {
                this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
                continue;
            }
            DiagramNodePart nodePart2 = this.diagramEditor.getDiagramNodePart(endpt2);
            if (nodePart2 == null || nodePart2.getDiagramNodeTemplate() != nodeTemplate) continue;
            this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
        }
    }

    protected void setModelProperty(Element modelElement, String propertyName, Object value) {
        if (propertyName != null) {
            ElementType type = modelElement.type();
            PropertyDef property = type.property(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            if (!(property instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            modelElement.property((ValueProperty)property).write(value);
        }
    }

    protected FunctionResult getNodeReferenceFunction(DiagramNodePart nodePart, Value<Function> function, LocalizationService ls) {
        Function f = null;
        FunctionResult fr = null;
        if (function != null) {
            f = (Function)function.content();
        }
        if (f != null) {
            f = FailSafeFunction.create((Function)f, (Function)Literal.create(String.class));
            fr = f.evaluate((FunctionContext)new ModelElementFunctionContext(nodePart.getLocalModelElement(), ls));
        }
        return fr;
    }

    protected void handleConnectionListChange(Element connListParent, ListProperty listProperty) {
        ElementList newList = connListParent.property(listProperty);
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(connListParent);
        ArrayList<Element> oldList = new ArrayList<Element>(connParts.size());
        for (StandardDiagramConnectionPart connPart : connParts) {
            oldList.add(connPart.getLocalModelElement());
        }
        List deletedConns = CollectionsUtil.removedBasedOnEntryIdentity(oldList, (List)newList);
        List newConns = CollectionsUtil.removedBasedOnEntryIdentity((List)newList, oldList);
        for (Element deletedConn : deletedConns) {
            StandardDiagramConnectionPart connPart = this.getConnectionPart(connListParent, deletedConn);
            if (connPart == null) continue;
            this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
            this.disposeConnectionPart(connPart);
        }
        for (Element newConn : newConns) {
            this.createNewConnectionPart(newConn, connListParent);
        }
    }

    protected void handleModelPropertyChange(PropertyEvent event) {
        Element element = event.property().element();
        ListProperty property = (ListProperty)event.property().definition();
        ElementList newList = element.property(property);
        if (property == this.connListProperty) {
            this.handleConnectionListChange(element, property);
        } else if (property == this.modelProperty) {
            List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(null);
            ArrayList<Element> oldList = new ArrayList<Element>();
            HashSet<Element> oldConnParents = new HashSet<Element>();
            for (StandardDiagramConnectionPart connPart : connParts) {
                Element connElement = connPart.getLocalModelElement();
                Element connParentElement = connElement.parent().element();
                if (oldConnParents.contains(connParentElement)) continue;
                oldConnParents.add(connParentElement);
            }
            Iterator it = oldConnParents.iterator();
            while (it.hasNext()) {
                oldList.add((Element)it.next());
            }
            List deletedConnParents = CollectionsUtil.removedBasedOnEntryIdentity(oldList, (List)newList);
            List newConnParents = CollectionsUtil.removedBasedOnEntryIdentity((List)newList, oldList);
            ArrayList<StandardDiagramConnectionPart> connPartsCopy = new ArrayList<StandardDiagramConnectionPart>(connParts.size());
            connPartsCopy.addAll(connParts);
            for (StandardDiagramConnectionPart connPart : connPartsCopy) {
                Element connElement = connPart.getLocalModelElement();
                Element connParentElement = connElement.parent().element();
                if (!deletedConnParents.contains(connParentElement)) continue;
                this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
                this.disposeConnectionPart(connPart);
            }
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            for (Element newConnParent : newConnParents) {
                newConnParent.attach(this.modelPropertyListener, head.getPropertyName());
                this.handleConnectionListChange(newConnParent, this.connListProperty);
            }
        }
    }

    protected void addConnectionPart(Element srcNodeModel, StandardDiagramConnectionPart connPart) {
        this.diagramConnections.add(connPart);
    }

    protected void disposeConnectionPart(StandardDiagramConnectionPart connPart) {
        connPart.dispose();
        connPart.detach(this.connPartListener);
        this.diagramConnections.remove(connPart);
    }

    protected StandardDiagramConnectionPart getConnectionPart(Element srcNodeModel, Element connModel) {
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(srcNodeModel);
        for (StandardDiagramConnectionPart connPart : connParts) {
            if (connPart.getLocalModelElement() != connModel) continue;
            return connPart;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.removeModelListener();
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (StandardDiagramConnectionPart connPart : connParts) {
            this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
            connPart.dispose();
        }
    }

    protected void notifyConnectionEndpointUpdate(ConnectionEndpointsEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionEndpointUpdate(event);
        }
    }

    protected void notifyConnectionAddEvent(ConnectionAddEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionAddEvent(event);
        }
    }

    protected void notifyConnectionDeleteEvent(ConnectionDeleteEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionDeleteEvent(event);
        }
    }

    public static enum ConnectionType {
        OneToOne,
        OneToMany,
        Embedded;

    }

    public static abstract class DiagramConnectionTemplateListener {
        public void handleConnectionEndpointUpdate(ConnectionEndpointsEvent event) {
        }

        public void handleConnectionAddEvent(ConnectionAddEvent event) {
        }

        public void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
        }
    }
}

