/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.sqlschema;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.samples.sqlschema.Column;
import org.eclipse.sapphire.samples.sqlschema.Table;
import org.eclipse.sapphire.services.ReferenceService;

public class ColumnReferenceService
extends ReferenceService {
    private Table table;
    private Listener listener;

    public final Object resolve(String reference) {
        Table table = this.table();
        if (this.table != table) {
            if (this.table != null) {
                this.table.detach(this.listener, "Columns/Name");
                this.table = null;
            }
            if (table != null) {
                if (this.listener == null) {
                    this.listener = new FilteredListener<PropertyContentEvent>(){

                        protected void handleTypedEvent(PropertyContentEvent event) {
                            ColumnReferenceService.this.broadcast();
                        }
                    };
                }
                this.table = table;
                this.table.attach(this.listener, "Columns/Name");
            }
        }
        if (table != null && reference != null) {
            for (Column column : table.getColumns()) {
                String n = (String)column.getName().content();
                if (n == null || !n.equals(reference)) continue;
                return column;
            }
        }
        return null;
    }

    protected Table table() {
        return (Table)this.context(Table.class);
    }

    public void dispose() {
        if (this.table != null) {
            this.table.detach(this.listener, "Columns/Name");
            this.table = null;
            this.listener = null;
        }
        super.dispose();
    }
}

