/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.internal.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.internal.StandardDiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.internal.StandardEmbeddedConnectionPart;

public class DiagramEmbeddedConnectionTemplate
extends DiagramConnectionTemplate {
    private DiagramNodeTemplate nodeTemplate;
    private Map<Element, List<StandardDiagramConnectionPart>> diagramConnectionMap;
    private Listener modelElementListener;
    private ModelPath endpointPath;

    public DiagramEmbeddedConnectionTemplate(IDiagramExplicitConnectionBindingDef connBindingDef) {
        super(connBindingDef);
    }

    @Override
    public void init() {
        this.nodeTemplate = (DiagramNodeTemplate)this.parent();
        this.diagramEditor = this.nodeTemplate.getDiagramEditorPart();
        this.connectionDef = (IDiagramConnectionDef)super.definition();
        this.diagramConnectionMap = new HashMap<Element, List<StandardDiagramConnectionPart>>();
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        this.propertyName = (String)this.bindingDef.getProperty().content();
        this.connListProperty = (ListProperty)nodeProperty.getType().property(this.propertyName);
        this.initConnPartListener();
        this.templateListeners = new CopyOnWriteArraySet();
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramEmbeddedConnectionTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.modelElementListener = new FilteredListener<ElementDisposeEvent>(){

            protected void handleTypedEvent(ElementDisposeEvent event) {
                DiagramEmbeddedConnectionTemplate.this.handleModelElementDispose(event);
            }
        };
        String endpointPropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().content()).getProperty().content();
        this.endpointPath = new ModelPath(endpointPropStr);
        ElementList srcNodeList = this.getModelElement().property(nodeProperty);
        for (Element srcNodeModel : srcNodeList) {
            PropertyDef connProp = srcNodeModel.property(this.propertyName).definition();
            if (!(connProp instanceof ListProperty)) continue;
            ListProperty connListProperty = (ListProperty)connProp;
            ElementList connList = srcNodeModel.property(connListProperty);
            for (Element endpointModel : connList) {
                this.createNewConnectionPart(endpointModel, srcNodeModel);
            }
            this.addModelListener(srcNodeModel);
        }
    }

    public void refreshConnections(Element srcNodeModel) {
        PropertyDef connProp = srcNodeModel.property(this.propertyName).definition();
        this.handleConnectionListChange(srcNodeModel, (ListProperty)connProp);
    }

    @Override
    public boolean canStartNewConnection(DiagramNodePart srcNode) {
        ElementType desiredsrcNodeType;
        Element srcNodeModel = srcNode.getLocalModelElement();
        ElementType srcNodeType = srcNodeModel.type();
        return srcNodeType.equals(desiredsrcNodeType = this.nodeTemplate.getNodeType());
    }

    @Override
    public boolean canCreateNewConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        if (!this.canStartNewConnection(srcNode)) {
            return false;
        }
        Element srcNodeModel = srcNode.getLocalModelElement();
        ElementType targetType = targetNode.getLocalModelElement().type();
        PropertyDef connProp = srcNodeModel.property(this.propertyName).definition();
        ElementType connType = connProp.getType();
        PropertyDef endpointProp = connType.property((String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().content()).getProperty().content());
        if (endpointProp.getType() == null && endpointProp.hasAnnotation(Reference.class)) {
            return ((Reference)endpointProp.getAnnotation(Reference.class)).target().isAssignableFrom(targetType.getModelElementClass());
        }
        return false;
    }

    @Override
    public void setSerializedEndpoint2(Element connModelElement, String endpoint2Value) {
        IDiagramConnectionEndpointBindingDef endpointDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().content();
        String endpointProperty = (String)endpointDef.getProperty().content();
        this.setModelProperty(connModelElement, endpointProperty, endpoint2Value);
    }

    @Override
    public StandardDiagramConnectionPart createNewDiagramConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        Element srcNodeModel = srcNode.getLocalModelElement();
        PropertyDef modelProperty = this.nodeTemplate.getModelProperty();
        boolean found = false;
        if (modelProperty instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)modelProperty;
            ElementList list = this.getModelElement().property(listProperty);
            for (Element listEntryModelElement : list) {
                if (listEntryModelElement != srcNodeModel) continue;
                found = true;
                break;
            }
        } else if (modelProperty instanceof ElementProperty) {
            Element localModelElement;
            ElementProperty elementProperty = (ElementProperty)modelProperty;
            if (this.getModelElement().property(elementProperty) != null && (localModelElement = this.getModelElement().property(elementProperty).content()) == srcNodeModel) {
                found = true;
            }
        }
        if (!found) {
            throw new RuntimeException("Cannot locate the source node element");
        }
        PropertyDef connProp = srcNodeModel.property(this.propertyName).definition();
        Element newEndpoint = null;
        if (connProp instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)connProp;
            ElementList list = srcNodeModel.property(listProperty);
            newEndpoint = list.insert();
        }
        String endpointVal = this.getSerializedEndpoint2(targetNode);
        this.setSerializedEndpoint2(newEndpoint, endpointVal);
        StandardDiagramConnectionPart connPart = this.getConnectionPart(srcNodeModel, newEndpoint);
        if (connPart == null) {
            connPart = this.createNewConnectionPart(newEndpoint, srcNodeModel);
        }
        return connPart;
    }

    @Override
    protected StandardDiagramConnectionPart createNewConnectionPart(Element connElement, Element srcNodeElement) {
        StandardEmbeddedConnectionPart connPart = new StandardEmbeddedConnectionPart(this.bindingDef, srcNodeElement, this.endpointPath);
        connPart.init(this, connElement, this.connectionDef, Collections.<String, String>emptyMap());
        connPart.initialize();
        connPart.attach(this.connPartListener);
        this.addConnectionPart(srcNodeElement, connPart);
        return connPart;
    }

    public void addModelListener(Element srcNodeModel) {
        srcNodeModel.attach(this.modelPropertyListener, this.propertyName);
        srcNodeModel.attach(this.modelElementListener);
    }

    public void removeModelListener(Element srcNodeModel) {
        srcNodeModel.detach(this.modelPropertyListener, this.propertyName);
        srcNodeModel.detach(this.modelElementListener);
    }

    @Override
    public void addModelListener() {
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        ElementList srcNodeList = this.getModelElement().property(nodeProperty);
        for (Element srcNodeModel : srcNodeList) {
            this.addModelListener(srcNodeModel);
        }
    }

    @Override
    public void removeModelListener() {
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        ElementList srcNodeList = this.getModelElement().property(nodeProperty);
        for (Element srcNodeModel : srcNodeList) {
            this.removeModelListener(srcNodeModel);
        }
    }

    @Override
    public List<StandardDiagramConnectionPart> getDiagramConnections(Element srcNodeModel) {
        ArrayList<StandardDiagramConnectionPart> allConnParts = new ArrayList<StandardDiagramConnectionPart>();
        if (srcNodeModel != null) {
            if (this.diagramConnectionMap.get(srcNodeModel) != null) {
                allConnParts.addAll((Collection<StandardDiagramConnectionPart>)this.diagramConnectionMap.get(srcNodeModel));
            }
        } else {
            for (List<StandardDiagramConnectionPart> connParts : this.diagramConnectionMap.values()) {
                allConnParts.addAll(connParts);
            }
        }
        return allConnParts;
    }

    @Override
    public void addConnectionPart(Element srcNodeModel, StandardDiagramConnectionPart connPart) {
        List<StandardDiagramConnectionPart> connParts = this.diagramConnectionMap.get(srcNodeModel);
        if (connParts == null) {
            connParts = new ArrayList<StandardDiagramConnectionPart>();
            this.diagramConnectionMap.put(srcNodeModel, connParts);
        }
        connParts.add(connPart);
    }

    @Override
    public void disposeConnectionPart(StandardDiagramConnectionPart connPart) {
        connPart.dispose();
        connPart.detach(this.connPartListener);
        Collection<List<StandardDiagramConnectionPart>> allConnParts = this.diagramConnectionMap.values();
        for (List<StandardDiagramConnectionPart> connParts : allConnParts) {
            if (!connParts.contains(connPart)) continue;
            connParts.remove(connPart);
            break;
        }
    }

    public void removeConnectionParts(Element srcNodeModel) {
        ArrayList<StandardDiagramConnectionPart> connParts = new ArrayList<StandardDiagramConnectionPart>();
        connParts.addAll(this.getDiagramConnections(srcNodeModel));
        for (StandardDiagramConnectionPart connPart : connParts) {
            this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
            this.disposeConnectionPart(connPart);
        }
    }

    @Override
    public DiagramConnectionTemplate.ConnectionType getConnectionType() {
        return DiagramConnectionTemplate.ConnectionType.Embedded;
    }

    private void handleModelElementDispose(ElementDisposeEvent event) {
        Element element = event.element();
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (StandardDiagramConnectionPart connPart : connParts) {
            if (connPart.getEndpoint1() != element && connPart.getEndpoint2() != element) continue;
            this.notifyConnectionDeleteEvent(new ConnectionDeleteEvent(connPart));
            this.disposeConnectionPart(connPart);
        }
        this.removeModelListener(element);
    }
}

