/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.widgets.Shell;

public final class JavaTypeJumpActionHandler
extends JumpActionHandler {
    public static final String ID = "Sapphire.Jump.Java.Type";
    @Text(value="Type Not Found")
    private static LocalizableText couldNotFindTypeDialogTitle;
    @Text(value="Could not find {0} on project classpath.")
    private static LocalizableText couldNotFindTypeDialogMessage;

    static {
        LocalizableText.init(JavaTypeJumpActionHandler.class);
    }

    public JavaTypeJumpActionHandler() {
        this.setId(ID);
    }

    protected boolean computeEnablementState() {
        Value value;
        String typeName;
        return super.computeEnablementState() && (typeName = (value = (Value)this.property()).text(true)) != null && JavaTypeJumpActionHandler.getType(typeName, (IProject)value.element().adapt(IProject.class)) != null;
    }

    protected Object run(Presentation context) {
        Value value = (Value)this.property();
        String typeName = value.text(true);
        if (typeName != null) {
            IType type = JavaTypeJumpActionHandler.getType(typeName, (IProject)value.element().adapt(IProject.class));
            try {
                if (type != null) {
                    JavaUI.openInEditor((IJavaElement)type);
                } else {
                    String message = couldNotFindTypeDialogMessage.format(new Object[]{typeName});
                    MessageDialog.openInformation((Shell)((FormComponentPresentation)context).shell(), (String)couldNotFindTypeDialogTitle.text(), (String)message);
                }
            }
            catch (CoreException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        return null;
    }

    private static IType getType(String fullyQualifiedType, IProject project) {
        assert (fullyQualifiedType != null) : "Fully qualified type should not be null.";
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        String name = fullyQualifiedType.replace('$', '.');
        IType type = null;
        try {
            type = javaProject.findType(name);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return type;
    }
}

