/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.swt.gef.figures.IShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.TextPresentation;

public class TextFigure
extends Label
implements IShapeFigure {
    private DiagramResourceCache resourceCache;
    private TextPresentation textPresentation;
    private Rectangle availableArea;
    private int horizontalAlignment;
    private int verticalAlignment;

    public TextFigure(DiagramResourceCache resourceCache, TextPresentation textPresentation) {
        this.resourceCache = resourceCache;
        this.textPresentation = textPresentation;
        this.setForegroundColor(resourceCache.getColor(textPresentation.getTextColor()));
        this.horizontalAlignment = this.getSwtTextAlignment((HorizontalAlignment)textPresentation.getLayoutConstraint().getHorizontalAlignment().content());
        this.setLabelAlignment(this.horizontalAlignment);
        this.verticalAlignment = this.getSwtTextAlignment((VerticalAlignment)textPresentation.getLayoutConstraint().getVerticalAlignment().content());
        this.setFont(this.resourceCache.getFont(textPresentation.getFontDef()));
        this.setText(textPresentation.getContent());
    }

    public Rectangle getAvailableArea() {
        IFigure nodeFigure = this.textPresentation.getNodeFigure();
        Rectangle nodeBounds = nodeFigure.getBounds();
        if (this.availableArea != null) {
            return new Rectangle(this.availableArea.x + nodeBounds.x, this.availableArea.y + nodeBounds.y, this.availableArea.width, this.availableArea.height);
        }
        return nodeBounds;
    }

    public void setAvailableArea(Rectangle availableArea) {
        IFigure nodeFigure = this.textPresentation.getNodeFigure();
        Rectangle nodeBounds = nodeFigure.getBounds();
        this.availableArea = new Rectangle(availableArea.x - nodeBounds.x, availableArea.y - nodeBounds.y, availableArea.width, availableArea.height);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.setLabelAlignment(this.horizontalAlignment);
    }

    public TextPresentation getTextPresentation() {
        return this.textPresentation;
    }

    public Dimension getMinimumSize(int w, int h) {
        Dimension minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            minSize.setSize(this.getLayoutManager().getMinimumSize((IFigure)this, w, h));
        }
        Dimension labelSize = this.getTextPresentation().truncatable() ? this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getTruncationString(), this.getFont()).intersect(this.getTextUtilities().getTextExtents(this.getText(), this.getFont()))) : this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getText(), this.getFont()));
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        minSize.union(labelSize);
        return minSize;
    }

    public Dimension getMaximumSize() {
        return this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getText(), this.getFont()));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getText(), this.getFont()));
    }

    private int getSwtTextAlignment(HorizontalAlignment horizontalAlign) {
        int alignment = 2;
        switch (horizontalAlign) {
            case LEFT: {
                alignment = 1;
                break;
            }
            case RIGHT: {
                alignment = 4;
                break;
            }
        }
        return alignment;
    }

    private int getSwtTextAlignment(VerticalAlignment verticalAlign) {
        int alignment = 2;
        switch (verticalAlign) {
            case TOP: {
                alignment = 8;
                break;
            }
            case BOTTOM: {
                alignment = 32;
                break;
            }
        }
        return alignment;
    }

    @Override
    public void setSelected(boolean b) {
    }

    @Override
    public void setFocus(boolean b) {
    }
}

