/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address;

import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class CityPossibleValuesService
extends PossibleValuesService {
    @Text(value="\"{0}\" is not a valid city for the specified state and ZIP code.")
    private static LocalizableText invalidValueMessage;

    static {
        LocalizableText.init(CityPossibleValuesService.class);
    }

    protected void init() {
        final Address address = (Address)this.context(Address.class);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                String city;
                CityPossibleValuesService.this.broadcast();
                Set values = CityPossibleValuesService.this.values();
                if (values.size() == 1 && !(city = (String)values.iterator().next()).equalsIgnoreCase(address.getCity().text())) {
                    address.setCity(city);
                }
            }
        };
        address.getState().attach((Listener)listener);
        address.getZipCode().attach((Listener)listener);
    }

    protected void fillPossibleValues(Set<String> values) {
        Address address = (Address)this.context(Address.class);
        String state = address.getState().text();
        String zip = address.getZipCode().text();
        values.addAll(ZipCodeRepository.getCities(zip, state));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return invalidValueMessage.format(new Object[]{invalidValue});
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

