/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.xml.schema.normalizer.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.sdk.xml.schema.normalizer.CreateNormalizedXmlSchemaOp;
import org.eclipse.sapphire.sdk.xml.schema.normalizer.internal.PersistedState;
import org.eclipse.sapphire.sdk.xml.schema.normalizer.internal.PersistedStateManager;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.InitialValueServiceData;

public final class CreateNormalizedXmlSchemaOpServices {

    public static final class FolderInitialValueService
    extends InitialValueService {
        protected InitialValueServiceData compute() {
            return new InitialValueServiceData(null);
        }
    }

    public static final class SourceFileInitialValueService
    extends InitialValueService {
        private Listener listener;

        protected void initInitialValueService() {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    SourceFileInitialValueService.this.refresh();
                }
            };
            ((CreateNormalizedXmlSchemaOp)this.context(CreateNormalizedXmlSchemaOp.class)).getContext().attach(this.listener);
        }

        protected InitialValueServiceData compute() {
            CreateNormalizedXmlSchemaOp op = (CreateNormalizedXmlSchemaOp)this.context(CreateNormalizedXmlSchemaOp.class);
            IResource resource = (IResource)op.getContext().content();
            if (resource instanceof IFile && resource.getName().toLowerCase().endsWith(".xsd")) {
                return new InitialValueServiceData(resource.getFullPath().makeRelative().toPortableString());
            }
            return new InitialValueServiceData(null);
        }

        public void dispose() {
            CreateNormalizedXmlSchemaOp op;
            super.dispose();
            if (this.listener != null && !(op = (CreateNormalizedXmlSchemaOp)this.context(CreateNormalizedXmlSchemaOp.class)).disposed()) {
                op.getContext().detach(this.listener);
            }
        }
    }

    public static final class SourceFileListener
    extends FilteredListener<PropertyContentEvent> {
        protected void handleTypedEvent(PropertyContentEvent event) {
            IFile sourceFile;
            CreateNormalizedXmlSchemaOp op = (CreateNormalizedXmlSchemaOp)event.property().element();
            Path sourceFilePath = (Path)op.getSourceFile().content();
            String folder = null;
            String fileName = null;
            if (sourceFilePath != null && sourceFilePath.segmentCount() >= 2 && (sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(PathBridge.create((Path)sourceFilePath))).exists()) {
                folder = sourceFile.getParent().getFullPath().makeRelative().toPortableString();
                fileName = sourceFile.getName();
                fileName = fileName.toLowerCase().endsWith(".xsd") ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "-normalized.xsd" : null;
            }
            op.setFolder(folder);
            op.setFile(fileName);
            PersistedState state = PersistedStateManager.load(sourceFilePath);
            if (state == null) {
                op.getRootElements().clear();
            } else {
                try {
                    op.getRootElements().copy((Element)state);
                    op.getExclusions().copy((Element)state);
                    op.getTypeSubstitutions().copy((Element)state);
                    op.getSortSequenceContent().copy((Element)state);
                    op.getRemoveWildcards().copy((Element)state);
                }
                finally {
                    state.dispose();
                }
            }
        }
    }
}

