/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.EditorPageState;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributorPart;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class SapphireEditorPagePart
extends SapphirePart
implements PropertiesViewContributorPart {
    private EditorPageState state;
    private PropertiesViewContributionPart propertiesViewContributionPart;
    private FunctionResult pageHeaderTextFunctionResult;
    private FunctionResult pageHeaderImageFunctionResult;

    @Override
    protected void init() {
        super.init();
        EditorPageDef def = this.definition();
        this.pageHeaderTextFunctionResult = this.initExpression((Function)def.getPageHeaderText().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
                SapphireEditorPagePart.this.broadcast(new PageHeaderTextEvent(SapphireEditorPagePart.this));
            }
        });
        this.pageHeaderImageFunctionResult = this.initExpression((Function)def.getPageHeaderImage().content(), ImageData.class, null, new Runnable(){

            @Override
            public void run() {
                SapphireEditorPagePart.this.broadcast(new PageHeaderImageEvent(SapphireEditorPagePart.this));
            }
        });
    }

    @Override
    public EditorPageDef definition() {
        return (EditorPageDef)super.definition();
    }

    public synchronized EditorPageState state() {
        if (this.state == null) {
            StringBuilder key = new StringBuilder();
            IEditorInput editorInput = this.adapt(SapphireEditor.class).getEditorInput();
            key.append(editorInput.getClass().getName());
            key.append('#');
            if (editorInput instanceof IURIEditorInput) {
                URI uri = ((IURIEditorInput)editorInput).getURI();
                if (uri != null) {
                    key.append(((IURIEditorInput)editorInput).getURI().toString());
                } else {
                    key.append("%$**invalid**$%");
                }
                key.append('#');
            }
            key.append((String)this.definition().getPageName().content());
            String digest = MiscUtil.createStringDigest((String)key.toString());
            File file = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            file = new File(file, ".metadata/.plugins/org.eclipse.sapphire.ui/state");
            file = new File(file, digest);
            JavaType persistedStateElementJavaType = (JavaType)this.definition().getPersistentStateElementType().resolve();
            if (persistedStateElementJavaType == null) {
                throw new IllegalStateException();
            }
            ElementType persistedStateElementType = ElementType.read((Class)((Class)persistedStateElementJavaType.artifact()));
            try {
                RootXmlResource resource = new RootXmlResource(new XmlResourceStore(file));
                resource.setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

                    public boolean shouldAttemptRepair() {
                        return true;
                    }
                });
                this.state = (EditorPageState)persistedStateElementType.instantiate((Resource)resource);
            }
            catch (ResourceStoreException resourceStoreException) {
                this.state = (EditorPageState)persistedStateElementType.instantiate();
            }
        }
        return this.state;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.EditorPage");
    }

    @Override
    public IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().content();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                HelpSystem.getContext(docdef);
            }
        }
        return null;
    }

    @Override
    public final PropertiesViewContributionPart getPropertiesViewContribution() {
        return this.propertiesViewContributionPart;
    }

    public final void setPropertiesViewContribution(PropertiesViewContributionPart propertiesViewContributionPart) {
        if (this.propertiesViewContributionPart != propertiesViewContributionPart) {
            this.propertiesViewContributionPart = propertiesViewContributionPart;
            this.broadcast(new PropertiesViewContributionChangedEvent(this, propertiesViewContributionPart));
        }
    }

    public String getPageHeaderText() {
        return (String)this.pageHeaderTextFunctionResult.value();
    }

    public ImageData getPageHeaderImage() {
        return (ImageData)this.pageHeaderImageFunctionResult.value();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.state != null) {
            try {
                this.state.resource().save();
            }
            catch (Exception exception) {}
            this.state.dispose();
        }
        if (this.pageHeaderTextFunctionResult != null) {
            this.pageHeaderTextFunctionResult.dispose();
        }
        if (this.pageHeaderImageFunctionResult != null) {
            this.pageHeaderImageFunctionResult.dispose();
        }
    }

    public static final class PageHeaderImageEvent
    extends SapphirePart.PartEvent {
        public PageHeaderImageEvent(SapphireEditorPagePart part) {
            super(part);
        }
    }

    public static final class PageHeaderTextEvent
    extends SapphirePart.PartEvent {
        public PageHeaderTextEvent(SapphireEditorPagePart part) {
            super(part);
        }
    }

    public static final class PropertiesViewContributionChangedEvent
    extends SapphirePart.PartEvent {
        private final PropertiesViewContributionPart contribution;

        public PropertiesViewContributionChangedEvent(SapphirePart part, PropertiesViewContributionPart contribution) {
            super(part);
            this.contribution = contribution;
        }

        public PropertiesViewContributionPart contribution() {
            return this.contribution;
        }
    }

    public static final class SelectionChangedEvent
    extends SapphirePart.PartEvent {
        public SelectionChangedEvent(SapphirePart part) {
            super(part);
        }
    }
}

