/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.forms.CompositeDef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.FormDef;
import org.eclipse.sapphire.ui.forms.FormPart;
import org.eclipse.sapphire.ui.forms.PageBookCaseDef;
import org.eclipse.sapphire.ui.forms.PageBookCasePart;
import org.eclipse.sapphire.ui.forms.PageBookDef;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PageBookPresentation;
import org.eclipse.swt.widgets.Composite;

public abstract class PageBookPart
extends FormComponentPart {
    private static FormDef systemDefaultPageDef;
    private Map<ElementType, FormDef> pageDefs;
    private FormPart currentPage;
    private Map<PageCacheKey, FormPart> pages = Collections.synchronizedMap(new HashMap());
    private boolean exposePageValidationState = false;
    private Listener childPartValidationListener = null;

    @Override
    protected void init() {
        super.init();
        PageBookDef def = (PageBookDef)this.definition;
        this.pageDefs = new LinkedHashMap<ElementType, FormDef>();
        for (PageBookCaseDef cs : def.getCases()) {
            ElementType type = ElementType.read((Class)((Class)((JavaType)cs.getElementType().resolve()).artifact()));
            this.pageDefs.put(type, cs);
        }
        if (systemDefaultPageDef == null) {
            ISapphireUiDef root = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate();
            systemDefaultPageDef = (CompositeDef)root.getPartDefs().insert(CompositeDef.TYPE);
        }
    }

    @Override
    protected Function initVisibleWhenFunction() {
        Function function = new Function(){

            public String name() {
                return "VisibleIfChildrenVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        FilteredListener<PartVisibilityEvent> pageVisibilityListener = new FilteredListener<PartVisibilityEvent>(){

                            protected void handleTypedEvent(PartVisibilityEvent event) {
                                this.refresh();
                            }
                        };
                        PageBookPart.this.attach((Listener)new FilteredListener<PageChangedEvent>((Listener)pageVisibilityListener){
                            private final /* synthetic */ Listener val$pageVisibilityListener;
                            {
                                this.val$pageVisibilityListener = listener;
                            }

                            protected void handleTypedEvent(PageChangedEvent event) {
                                FormPart page = PageBookPart.this.getCurrentPage();
                                if (page != null) {
                                    page.attach(this.val$pageVisibilityListener);
                                }
                                this.refresh();
                            }
                        });
                        FormPart page = PageBookPart.this.getCurrentPage();
                        if (page != null) {
                            page.attach((Listener)pageVisibilityListener);
                        }
                    }

                    protected Object evaluate() {
                        boolean visible = false;
                        FormPart page = PageBookPart.this.getCurrentPage();
                        if (page != null) {
                            visible = page.visible();
                        }
                        return visible;
                    }
                };
            }
        };
        function.init(new Function[0]);
        Function base = super.initVisibleWhenFunction();
        if (base == null) {
            return function;
        }
        return AndFunction.create((Function[])new Function[]{base, function});
    }

    public final FormPart getCurrentPage() {
        return this.currentPage;
    }

    protected final void changePage(final Element elementForPage) {
        FormPart oldPage;
        Element pageElement = this.getLocalModelElement();
        FormDef pageDef = systemDefaultPageDef;
        if (elementForPage != null) {
            for (Map.Entry<ElementType, FormDef> entry : this.pageDefs.entrySet()) {
                if (!entry.getKey().getModelElementClass().isAssignableFrom(elementForPage.getClass())) continue;
                pageDef = entry.getValue();
                pageElement = elementForPage;
                break;
            }
        }
        if ((oldPage = this.currentPage) != null && this.childPartValidationListener != null) {
            oldPage.detach(this.childPartValidationListener);
        }
        this.currentPage = null;
        final PageCacheKey key = new PageCacheKey(pageDef, pageElement);
        this.currentPage = this.pages.get(key);
        if (this.currentPage == null) {
            this.currentPage = new PageBookCasePart();
            this.currentPage.init(this, pageElement, pageDef, this.params);
            this.currentPage.initialize();
            this.pages.put(key, this.currentPage);
            if (elementForPage != null) {
                FilteredListener<ElementDisposeEvent> elementDisposeListener = new FilteredListener<ElementDisposeEvent>(){

                    protected void handleTypedEvent(ElementDisposeEvent event) {
                        FormPart page = (FormPart)PageBookPart.this.pages.remove(key);
                        if (page != null) {
                            page.dispose();
                        }
                    }
                };
                elementForPage.attach((Listener)elementDisposeListener);
                FilteredListener<DisposeEvent> pageDisposeListener = new FilteredListener<DisposeEvent>((Listener)elementDisposeListener){
                    private final /* synthetic */ Listener val$elementDisposeListener;
                    {
                        this.val$elementDisposeListener = listener;
                    }

                    protected void handleTypedEvent(DisposeEvent event) {
                        elementForPage.detach(this.val$elementDisposeListener);
                    }
                };
                this.currentPage.attach((Listener)pageDisposeListener);
            }
        }
        if (this.childPartValidationListener != null) {
            this.currentPage.attach(this.childPartValidationListener);
        }
        this.refreshValidation();
        this.broadcast(new PageChangedEvent(this));
    }

    @Override
    protected Status computeValidation() {
        FormPart currentPage;
        if (this.exposePageValidationState && (currentPage = this.getCurrentPage()) != null) {
            return currentPage.validation();
        }
        return Status.createOkStatus();
    }

    protected final void setExposePageValidationState(boolean exposePageValidationState) {
        if (this.exposePageValidationState != exposePageValidationState) {
            this.exposePageValidationState = exposePageValidationState;
            if (this.exposePageValidationState) {
                this.childPartValidationListener = new FilteredListener<PartValidationEvent>(){

                    protected void handleTypedEvent(PartValidationEvent event) {
                        PageBookPart.this.refreshValidation();
                    }
                };
                if (this.currentPage != null) {
                    this.currentPage.attach(this.childPartValidationListener);
                }
            } else {
                this.childPartValidationListener = null;
            }
            this.refreshValidation();
        }
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new PageBookPresentation(this, parent, composite);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (FormPart page : this.pages.values()) {
            page.dispose();
        }
        this.pageDefs = null;
        this.currentPage = null;
        this.pages = null;
        this.childPartValidationListener = null;
    }

    private static final class PageCacheKey {
        private final FormDef def;
        private final Element element;

        public PageCacheKey(FormDef def, Element element) {
            this.def = def;
            this.element = element;
        }

        public int hashCode() {
            return System.identityHashCode(this.def) ^ System.identityHashCode(this.element);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PageCacheKey) {
                PageCacheKey key = (PageCacheKey)obj;
                return this.def == key.def && this.element == key.element;
            }
            return false;
        }
    }

    public static final class PageChangedEvent
    extends SapphirePart.PartEvent {
        public PageChangedEvent(SapphirePart part) {
            super(part);
        }
    }
}

