/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.annotations.InitialValue;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.InitialValueServiceData;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class StandardInitialValueService
extends InitialValueService {
    private FunctionResult functionResult;

    @Override
    protected void initInitialValueService() {
        String expr;
        InitialValue annotation = this.context(PropertyDef.class).getAnnotation(InitialValue.class);
        if (annotation != null && (expr = annotation.text()).length() > 0) {
            Function function = null;
            try {
                function = ExpressionLanguageParser.parse(expr);
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
                function = null;
            }
            if (function != null) {
                function = FailSafeFunction.create(function, Literal.create(String.class));
                ModelElementFunctionContext context = new ModelElementFunctionContext(this.context(Element.class));
                this.functionResult = function.evaluate(context);
                Listener listener = new Listener(){

                    @Override
                    public void handle(Event event) {
                        StandardInitialValueService.this.refresh();
                    }
                };
                this.functionResult.attach(listener);
            }
        }
    }

    @Override
    protected InitialValueServiceData compute() {
        if (this.functionResult == null) {
            return new InitialValueServiceData(null);
        }
        return new InitialValueServiceData((String)this.functionResult.value());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            if (property != null) {
                return property.hasAnnotation(InitialValue.class);
            }
            return false;
        }
    }
}

