/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address;

import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class ZipCodePossibleValuesService
extends PossibleValuesService {
    @Text(value="\"{0}\" is not a valid ZIP code for the specified city and state.")
    private static LocalizableText invalidValueMessage;

    static {
        LocalizableText.init(ZipCodePossibleValuesService.class);
    }

    protected void init() {
        final Address address = (Address)this.context(Address.class);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                String zip;
                ZipCodePossibleValuesService.this.broadcast();
                Set values = ZipCodePossibleValuesService.this.values();
                if (values.size() == 1 && !(zip = (String)values.iterator().next()).equalsIgnoreCase(address.getZipCode().text())) {
                    address.setZipCode(zip);
                }
            }
        };
        address.getCity().attach((Listener)listener);
        address.getState().attach((Listener)listener);
    }

    protected void fillPossibleValues(Set<String> values) {
        Address address = (Address)this.context(Address.class);
        String city = address.getCity().text();
        String state = address.getState().text();
        values.addAll(ZipCodeRepository.getZipCodes(state, city));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return invalidValueMessage.format(new Object[]{invalidValue});
    }
}

