/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.AbstractSlushBucketPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.ValueLabelProvider;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class SlushBucketPropertyEditorPresentation
extends AbstractSlushBucketPropertyEditorPresentation {
    private ElementType memberType;
    private ValueProperty memberProperty;
    private PossibleValuesService possibleValuesService;
    private Listener possibleValuesServiceListener;
    private TableViewer sourceTableViewer;
    private Table sourceTable;
    private MoveRightActionHandler moveRightActionHandler;

    public SlushBucketPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
        ElementList<?> property = this.property();
        this.memberType = property.definition().getType();
        this.memberProperty = (ValueProperty)this.memberType.properties().first();
        this.possibleValuesService = (PossibleValuesService)property.service(PossibleValuesService.class);
        Status.Severity invalidValueSeverity = this.possibleValuesService.getInvalidValueSeverity(null);
        this.setAddActionDesired(invalidValueSeverity != Status.Severity.ERROR);
    }

    @Override
    public Control createSourceControl(Composite parent) {
        PropertyEditorPart part = this.part();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        innerComposite.setLayout((Layout)tableColumnLayout);
        this.sourceTableViewer = new TableViewer(innerComposite, 67586);
        this.sourceTable = this.sourceTableViewer.getTable();
        boolean showHeader = part.getRenderingHint("show.header", true);
        this.sourceTable.setHeaderVisible(showHeader);
        TableViewerColumn viewerColumn = new TableViewerColumn(this.sourceTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (SlushBucketPropertyEditorPresentation.this.possibleValuesService == null) {
                    return new Object[0];
                }
                ElementList<?> list = SlushBucketPropertyEditorPresentation.this.list();
                if (list == null) {
                    return new Object[0];
                }
                Set possibleValues = SlushBucketPropertyEditorPresentation.this.possibleValuesService.values();
                SetFactory unusedPossibleValues = SetFactory.start().add((Collection)possibleValues);
                for (Element member : list) {
                    unusedPossibleValues.remove((Object)member.property(SlushBucketPropertyEditorPresentation.this.memberProperty).text());
                }
                return unusedPossibleValues.result().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        this.sourceTableViewer.setContentProvider((IContentProvider)contentProvider);
        final ValueLabelProvider valueLabelProvider = new ValueLabelProvider(part, this.memberProperty);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return valueLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return valueLabelProvider.getImage(element);
            }

            public void dispose() {
                super.dispose();
                valueLabelProvider.dispose();
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        SwtUtil.makeTableSortable(this.sourceTableViewer, Collections.<TableColumn, Comparator<Object>>emptyMap(), this.possibleValuesService.ordered() ? null : column);
        SwtUtil.suppressDashedTableEntryBorder(this.sourceTable);
        this.sourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                SlushBucketPropertyEditorPresentation.this.handleSourceTableDoubleClickEvent(event);
            }
        });
        this.sourceTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                SlushBucketPropertyEditorPresentation.this.handleSourceTableFocusGainedEvent();
            }
        });
        this.sourceTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == ' ') {
                    SlushBucketPropertyEditorPresentation.this.handleSourceTableEnterKeyPressEvent();
                }
            }
        });
        this.possibleValuesServiceListener = new Listener(){

            public void handle(Event event) {
                SlushBucketPropertyEditorPresentation.this.sourceTableViewer.refresh();
            }
        };
        this.possibleValuesService.attach(this.possibleValuesServiceListener);
        this.sourceTableViewer.setInput(new Object());
        this.addOnDisposeOperation(new Runnable(){

            @Override
            public void run() {
                if (SlushBucketPropertyEditorPresentation.this.possibleValuesService != null) {
                    SlushBucketPropertyEditorPresentation.this.possibleValuesService.detach(SlushBucketPropertyEditorPresentation.this.possibleValuesServiceListener);
                }
            }
        });
        return composite;
    }

    @Override
    public SapphireActionHandler createMoveRightActionHandler() {
        this.moveRightActionHandler = new MoveRightActionHandler();
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<String> input = new ArrayList<String>();
                Iterator itr = ((IStructuredSelection)event.getSelection()).iterator();
                while (itr.hasNext()) {
                    input.add((String)itr.next());
                }
                SlushBucketPropertyEditorPresentation.this.moveRightActionHandler.setInput(input);
            }
        };
        this.sourceTableViewer.addSelectionChangedListener(listener);
        return this.moveRightActionHandler;
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.sourceTableViewer.refresh();
    }

    @Override
    protected void handleChildPropertyEvent(PropertyContentEvent event) {
        super.handleChildPropertyEvent(event);
        this.sourceTableViewer.refresh();
    }

    @Override
    protected void handleTableFocusGainedEvent() {
        super.handleTableFocusGainedEvent();
        this.sourceTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void handleSourceTableDoubleClickEvent(MouseEvent event) {
        String doubleClickedItem = null;
        TableItem[] tableItemArray = this.sourceTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getBounds().contains(event.x, event.y)) {
                doubleClickedItem = (String)item.getData();
                break;
            }
            ++n2;
        }
        if (doubleClickedItem != null) {
            this.moveRightActionHandler.setInput(Collections.singleton(doubleClickedItem));
            this.moveRightActionHandler.execute(this);
        }
    }

    private void handleSourceTableFocusGainedEvent() {
        this.setSelectedElements(Collections.<Element>emptyList());
        if (this.sourceTableViewer.getSelection().isEmpty() && this.sourceTable.getItemCount() > 0) {
            String firstItem = (String)this.sourceTable.getItem(0).getData();
            this.sourceTableViewer.setSelection((ISelection)new StructuredSelection((Object)firstItem));
        }
    }

    private void handleSourceTableEnterKeyPressEvent() {
        if (!this.sourceTableViewer.getSelection().isEmpty()) {
            this.moveRightActionHandler.execute(this);
        }
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            PropertyDef memberProperty;
            SortedSet properties;
            Property property = part.property();
            if (property.definition() instanceof ListProperty && property.service(PossibleValuesService.class) != null && ((PossibleTypesService)property.service(PossibleTypesService.class)).types().size() == 1 && (properties = property.definition().getType().properties()).size() == 1 && (memberProperty = (PropertyDef)properties.first()) instanceof ValueProperty && memberProperty.hasAnnotation(NoDuplicates.class)) {
                return new SlushBucketPropertyEditorPresentation(part, parent, composite);
            }
            return null;
        }
    }

    private final class MoveRightActionHandler
    extends SapphireActionHandler {
        private Collection<String> input = Collections.emptyList();

        private MoveRightActionHandler() {
        }

        @Override
        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setEnabled(false);
        }

        public void setInput(Collection<String> input) {
            this.input = input;
            this.setEnabled(SlushBucketPropertyEditorPresentation.this.list() != null && !this.input.isEmpty());
        }

        @Override
        protected Object run(Presentation context) {
            ElementList<?> list = SlushBucketPropertyEditorPresentation.this.list();
            if (list != null) {
                ListFactory elements = ListFactory.start();
                for (String str : this.input) {
                    Element element = list.insert();
                    element.property(SlushBucketPropertyEditorPresentation.this.memberProperty).write((Object)str);
                    elements.add((Object)element);
                }
                SlushBucketPropertyEditorPresentation.this.setSelectedElements(elements.result());
                SlushBucketPropertyEditorPresentation.this.setFocusOnTable();
            }
            return null;
        }
    }
}

