/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.ui.internal;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class JavaTypeBrowseActionHandler
extends BrowseActionHandler {
    @Text(value="Select")
    private static LocalizableText select;
    @Text(value="Java type kind \"{0}\" is not recognized.")
    private static LocalizableText typeKindNotRecognized;
    public static final String ID = "Sapphire.Browse.Java.Type";
    public static final String PARAM_KINDS = "kinds";
    private String paramKinds;

    static {
        LocalizableText.init(JavaTypeBrowseActionHandler.class);
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.paramKinds = def.getParam(PARAM_KINDS);
    }

    public String browse(Presentation context) {
        int browseDialogStyle;
        Value property;
        block31: {
            int count;
            EnumSet<JavaTypeKind> kinds;
            block30: {
                property = this.property();
                kinds = EnumSet.noneOf(JavaTypeKind.class);
                if (this.paramKinds != null) {
                    String[] stringArray = this.paramKinds.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String kindString = stringArray[n2];
                        if ((kindString = kindString.trim()).equalsIgnoreCase(JavaTypeKind.CLASS.name())) {
                            kinds.add(JavaTypeKind.CLASS);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.ABSTRACT_CLASS.name())) {
                            kinds.add(JavaTypeKind.ABSTRACT_CLASS);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.INTERFACE.name())) {
                            kinds.add(JavaTypeKind.INTERFACE);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.ANNOTATION.name())) {
                            kinds.add(JavaTypeKind.ANNOTATION);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.ENUM.name())) {
                            kinds.add(JavaTypeKind.ENUM);
                        } else {
                            String msg = typeKindNotRecognized.format(new Object[]{kindString});
                            ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg);
                        }
                        ++n2;
                    }
                } else {
                    JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)property.service(JavaTypeConstraintService.class);
                    if (javaTypeConstraintService != null) {
                        kinds.addAll(javaTypeConstraintService.kinds());
                    }
                }
                browseDialogStyle = 256;
                count = kinds.size();
                if (count != 1) break block30;
                JavaTypeKind kind = (JavaTypeKind)kinds.iterator().next();
                switch (kind) {
                    case CLASS: {
                        browseDialogStyle = 2;
                        break block31;
                    }
                    case ABSTRACT_CLASS: {
                        browseDialogStyle = 2;
                        break block31;
                    }
                    case INTERFACE: {
                        browseDialogStyle = 4;
                        break block31;
                    }
                    case ANNOTATION: {
                        browseDialogStyle = 64;
                        break block31;
                    }
                    case ENUM: {
                        browseDialogStyle = 128;
                        break block31;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (count == 2 && (kinds.contains(JavaTypeKind.CLASS) || kinds.contains(JavaTypeKind.ABSTRACT_CLASS))) {
                if (kinds.contains(JavaTypeKind.INTERFACE)) {
                    browseDialogStyle = 512;
                } else if (kinds.contains(JavaTypeKind.ENUM)) {
                    browseDialogStyle = 1024;
                }
            }
        }
        IProject project = (IProject)property.element().adapt(IProject.class);
        try {
            SelectionDialog dlg = JavaUI.createTypeDialog((Shell)((FormComponentPresentation)context).shell(), null, (IProject)project, (int)browseDialogStyle, (boolean)false);
            String title = property.definition().getLabel(true, CapitalizationType.TITLE_STYLE, false);
            dlg.setTitle(select + title);
            if (dlg.open() == 0) {
                Object[] results = dlg.getResult();
                assert (results != null && results.length == 1);
                if (results[0] instanceof IType) {
                    return ((IType)results[0]).getFullyQualifiedName();
                }
            }
        }
        catch (JavaModelException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return null;
    }
}

