/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import java.io.File;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.StatusException;

public final class FileUtil {
    @Text(value="Failed to create directory \"{0}\".")
    private static LocalizableText failedToCreateDirectory;
    @Text(value="Location \"{0}\" is a file.")
    private static LocalizableText locationIsFile;

    static {
        LocalizableText.init(FileUtil.class);
    }

    public static void mkdirs(File f) throws StatusException {
        if (f.exists()) {
            if (f.isFile()) {
                String msg = locationIsFile.format(f.getAbsolutePath());
                throw new StatusException(Status.createErrorStatus(msg));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
            boolean isSuccessful = f.mkdir();
            if (!isSuccessful) {
                String msg = failedToCreateDirectory.format(f.getAbsolutePath());
                throw new StatusException(Status.createErrorStatus(msg));
            }
        }
    }
}

