/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;

public abstract class DataService<T>
extends Service {
    private static final Object INITIAL_DATA = new Object();
    @Text(value="Reentrant call detected during refresh in {0}")
    private static LocalizableText reentrantRefreshMessage;
    @Text(value="{0} data accessed prior to service initialization")
    private static LocalizableText dataAccessedPriorToInitMessage;
    @Text(value="{0}: {1}.compute() has failed")
    private static LocalizableText computeFailedMessage;
    private T data = INITIAL_DATA;
    private boolean initialized;
    private boolean refreshing;

    static {
        LocalizableText.init(DataService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void init() {
        Object object = this.context().lock();
        synchronized (object) {
            this.initDataService();
            this.initialized = true;
        }
    }

    protected void initDataService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T data() {
        Object object = this.context().lock();
        synchronized (object) {
            if (!this.initialized) {
                throw new IllegalStateException(dataAccessedPriorToInitMessage.format(this.getClass().getSimpleName()));
            }
            if (this.data == INITIAL_DATA) {
                this.refresh();
            }
            return this.data;
        }
    }

    protected abstract T compute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refresh() {
        Object object = this.context().lock();
        synchronized (object) {
            if (this.refreshing) {
                throw new IllegalStateException(reentrantRefreshMessage.format(this.getClass().getSimpleName()));
            }
            this.refreshing = true;
            boolean broadcast = false;
            try {
                T newData;
                try {
                    newData = this.compute();
                }
                catch (Exception e) {
                    ElementType type;
                    ServiceContext context = this.context();
                    PropertyDef property = context.find(PropertyDef.class);
                    String contextLabel = property != null ? String.valueOf(property.getModelElementType().getSimpleName()) + "." + property.name() : ((type = context.find(ElementType.class)) != null ? type.getSimpleName() : context.getClass().getSimpleName());
                    throw new RuntimeException(computeFailedMessage.format(contextLabel, this.getClass().getSimpleName()), e);
                }
                if (this.data == INITIAL_DATA) {
                    this.data = newData;
                } else if (!MiscUtil.equal(this.data, newData)) {
                    this.data = newData;
                    broadcast = true;
                }
            }
            finally {
                this.refreshing = false;
            }
            if (broadcast) {
                this.broadcast();
            }
        }
    }
}

