/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireParam;
import org.eclipse.sapphire.ui.forms.FormComponentDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeChildDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeFactoryCaseDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeFactoryDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeList;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeRef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributorPart;
import org.eclipse.sapphire.ui.forms.SectionDef;
import org.eclipse.sapphire.ui.forms.SectionPart;
import org.eclipse.sapphire.ui.forms.SectionRef;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.util.ListFactory;

public final class MasterDetailsContentNodePart
extends SapphirePart
implements PropertiesViewContributorPart {
    private static final ImageData IMG_CONTAINER_NODE = (ImageData)ImageData.readFromClassLoader(MasterDetailsContentNodePart.class, (String)"ContainerNode.png").required();
    private static final ImageData IMG_LEAF_NODE = (ImageData)ImageData.readFromClassLoader(MasterDetailsContentNodePart.class, (String)"LeafNode.png").required();
    @Text(value="Could not resolve node \"{0}\".")
    private static LocalizableText couldNotResolveNode;
    @Text(value="Could not resolve section = \"{0}\".")
    private static LocalizableText couldNotResolveSection;
    private MasterDetailsContentOutline contentTree;
    private MasterDetailsContentNodeDef definition;
    private Element modelElement;
    private ElementHandle<?> modelElementProperty;
    private MasterDetailsContentNodePart parentNode;
    private FunctionResult labelFunctionResult;
    private SapphirePart.ImageManager imageManager;
    private Listener childPartListener;
    private List<Object> rawChildren;
    private MasterDetailsContentNodeList nodes;
    private List<SectionPart> sections;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private boolean expanded;
    private boolean transformLabelCase = true;
    private final Function nodeFactoryVisibleFunction;

    static {
        LocalizableText.init(MasterDetailsContentNodePart.class);
    }

    public MasterDetailsContentNodePart() {
        this(null);
    }

    public MasterDetailsContentNodePart(Function nodeFactoryVisibleFunction) {
        this.nodeFactoryVisibleFunction = nodeFactoryVisibleFunction;
    }

    @Override
    protected void init() {
        super.init();
        ISapphirePart parent = this.parent();
        this.parentNode = parent instanceof MasterDetailsContentNodePart ? (MasterDetailsContentNodePart)parent : null;
        this.contentTree = this.nearest(MasterDetailsEditorPagePart.class).outline();
        this.definition = (MasterDetailsContentNodeDef)((SapphirePart)this).definition;
        ImpliedElementProperty modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.definition.getProperty().content());
        if (modelElementProperty != null) {
            this.modelElementProperty = this.getModelElement().property((ElementProperty)modelElementProperty);
            this.modelElement = this.modelElementProperty.content();
        } else {
            this.modelElement = this.getModelElement();
        }
        this.expanded = false;
        this.childPartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof PartValidationEvent || event instanceof PartVisibilityEvent) {
                    MasterDetailsContentNodePart.this.refreshValidation();
                }
            }
        };
        this.labelFunctionResult = this.initExpression((Function)this.definition.getLabel().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
                MasterDetailsContentNodePart.this.broadcast(new SapphirePart.LabelChangedEvent(MasterDetailsContentNodePart.this));
            }
        });
        Literal defaultImageLiteral = Literal.create((Object)(this.definition.getChildNodes().isEmpty() ? IMG_LEAF_NODE : IMG_CONTAINER_NODE));
        Function imageFunction = (Function)this.definition.getImage().content();
        this.imageManager = new SapphirePart.ImageManager(imageFunction, (Function)defaultImageLiteral);
        this.rawChildren = new ArrayList<Object>();
        ListFactory sectionsListFactory = ListFactory.start();
        for (FormComponentDef s : this.definition.getSections()) {
            HashMap<String, String> sectionParams;
            SectionDef sectionDefinition;
            if (s instanceof SectionDef) {
                sectionDefinition = (SectionDef)s;
                sectionParams = this.params;
            } else if (s instanceof SectionRef) {
                SectionRef sectionReference = (SectionRef)s;
                sectionDefinition = (SectionDef)sectionReference.getSection().resolve();
                if (sectionDefinition == null) {
                    String msg = couldNotResolveSection.format(new Object[]{sectionReference.getSection().text()});
                    throw new RuntimeException(msg);
                }
                sectionParams = new HashMap<String, String>(this.params);
                for (ISapphireParam param : sectionReference.getParams()) {
                    String paramName = param.getName().text();
                    String paramValue = param.getValue().text();
                    if (paramName == null || paramValue == null) continue;
                    sectionParams.put(paramName, paramValue);
                }
            } else {
                throw new IllegalStateException();
            }
            SectionPart section = new SectionPart();
            section.init(this, this.modelElement, sectionDefinition, (Map<String, String>)sectionParams);
            section.initialize();
            section.attach(this.childPartListener);
            sectionsListFactory.add((Object)section);
        }
        this.sections = sectionsListFactory.result();
        for (MasterDetailsContentNodeChildDef entry : this.definition.getChildNodes()) {
            HashMap<String, String> params = new HashMap<String, String>(this.params);
            if (entry instanceof MasterDetailsContentNodeRef) {
                MasterDetailsContentNodeRef inc = (MasterDetailsContentNodeRef)entry;
                if ((entry = inc.resolve()) == null) {
                    String msg = couldNotResolveNode.format(new Object[]{inc.getPart()});
                    throw new RuntimeException(msg);
                }
                for (ISapphireParam param : inc.getParams()) {
                    String paramName = param.getName().text();
                    String paramValue = param.getValue().text();
                    if (paramName == null || paramValue == null) continue;
                    params.put(paramName, paramValue);
                }
            }
            if (entry instanceof MasterDetailsContentNodeDef) {
                MasterDetailsContentNodeDef def = (MasterDetailsContentNodeDef)entry;
                MasterDetailsContentNodePart node = new MasterDetailsContentNodePart();
                node.init(this, this.modelElement, def, params);
                node.initialize();
                node.attach(this.childPartListener);
                this.rawChildren.add(node);
                continue;
            }
            if (entry instanceof MasterDetailsContentNodeFactoryDef) {
                NodeFactory factory = new NodeFactory((MasterDetailsContentNodeFactoryDef)entry, params);
                this.rawChildren.add(factory);
                continue;
            }
            throw new IllegalStateException();
        }
        this.refreshNodes();
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof PartVisibilityEvent || event instanceof NodeListEvent) {
                    MasterDetailsContentNodePart.this.getContentTree().refreshSelection();
                }
            }
        });
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), MasterDetailsContentNodePart.createVersionCompatibleFunction(this.modelElementProperty), this.nodeFactoryVisibleFunction != null ? this.nodeFactoryVisibleFunction : new Function(){

            public String name() {
                return "VisibleIfChildrenVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        FilteredListener<PartVisibilityEvent> listener = new FilteredListener<PartVisibilityEvent>(){

                            protected void handleTypedEvent(PartVisibilityEvent event) {
                                this.refresh();
                            }
                        };
                        for (SapphirePart sapphirePart : MasterDetailsContentNodePart.this.getSections()) {
                            sapphirePart.attach((Listener)listener);
                        }
                        for (SectionPart sectionPart : MasterDetailsContentNodePart.this.rawChildren) {
                            if (sectionPart instanceof MasterDetailsContentNodePart) {
                                ((MasterDetailsContentNodePart)((Object)sectionPart)).attach((Listener)listener);
                                continue;
                            }
                            if (!(sectionPart instanceof NodeFactory)) continue;
                            ((NodeFactory)((Object)sectionPart)).attach((Listener)listener);
                        }
                    }

                    protected Object evaluate() {
                        boolean visible = false;
                        for (SectionPart section : MasterDetailsContentNodePart.this.getSections()) {
                            if (!section.visible()) continue;
                            visible = true;
                            break;
                        }
                        if (!visible) {
                            boolean bl = visible = MasterDetailsContentNodePart.this.getChildNodeFactoryProperties().size() > 0;
                        }
                        if (!visible) {
                            for (SectionPart entry : MasterDetailsContentNodePart.this.rawChildren) {
                                MasterDetailsContentNodePart node;
                                if (!(entry instanceof MasterDetailsContentNodePart) || !(node = (MasterDetailsContentNodePart)((Object)entry)).visible()) continue;
                                visible = true;
                                break;
                            }
                        }
                        return visible;
                    }
                };
            }
        }});
    }

    public MasterDetailsContentOutline getContentTree() {
        return this.contentTree;
    }

    public MasterDetailsContentNodePart getParentNode() {
        return this.parentNode;
    }

    public boolean isAncestorOf(MasterDetailsContentNodePart node) {
        MasterDetailsContentNodePart n = node;
        while (n != null) {
            if (n == this) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    @Override
    public Element getLocalModelElement() {
        return this.modelElement;
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        if (label == null) {
            label = "#null#";
        } else {
            label = label.trim();
            CapitalizationType capType = this.transformLabelCase ? CapitalizationType.TITLE_STYLE : CapitalizationType.NO_CAPS;
            label = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(label, capType, false);
        }
        return label;
    }

    public ImageDescriptor getImage() {
        return this.imageManager.getImage();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    public void setExpanded(boolean expanded, boolean applyToChildren) {
        if (this.parentNode != null && !this.parentNode.isExpanded() && expanded) {
            this.parentNode.setExpanded(true);
        }
        if (this.expanded != expanded) {
            MasterDetailsContentNodePart selection;
            if (!expanded && (selection = this.getContentTree().getSelectedNode()) != null && this.isAncestorOf(selection)) {
                this.select();
            }
            if (expanded) {
                this.expanded = expanded;
                this.getContentTree().notifyOfNodeExpandedStateChange(this);
            }
        }
        if (applyToChildren) {
            for (MasterDetailsContentNodePart child : this.nodes()) {
                if (child.nodes().visible().isEmpty()) continue;
                child.setExpanded(expanded, applyToChildren);
            }
        }
        if (this.expanded != expanded && !expanded) {
            this.expanded = expanded;
            this.getContentTree().notifyOfNodeExpandedStateChange(this);
        }
    }

    public List<MasterDetailsContentNodePart> getExpandedNodes() {
        ArrayList<MasterDetailsContentNodePart> result = new ArrayList<MasterDetailsContentNodePart>();
        this.getExpandedNodes(result);
        return result;
    }

    public void getExpandedNodes(List<MasterDetailsContentNodePart> result) {
        if (this.isExpanded()) {
            result.add(this);
            for (MasterDetailsContentNodePart child : this.nodes()) {
                child.getExpandedNodes(result);
            }
        }
    }

    public void select() {
        this.getContentTree().setSelectedNode(this);
    }

    public List<SectionPart> getSections() {
        return this.sections;
    }

    public List<PropertyDef> getChildNodeFactoryProperties() {
        ArrayList<PropertyDef> properties = new ArrayList<PropertyDef>();
        for (Object object : this.rawChildren) {
            NodeFactory factory;
            if (!(object instanceof NodeFactory) || !(factory = (NodeFactory)object).visible()) continue;
            properties.add(factory.property().definition());
        }
        return properties;
    }

    public List<NodeFactory> factories() {
        ListFactory factories = ListFactory.start();
        for (Object entry : this.rawChildren) {
            if (!(entry instanceof NodeFactory)) continue;
            factories.add((Object)((NodeFactory)entry));
        }
        return factories.result();
    }

    public MasterDetailsContentNodeList nodes() {
        if (this.nodes == null) {
            this.nodes = new MasterDetailsContentNodeList(Collections.<MasterDetailsContentNodePart>emptyList());
        }
        return this.nodes;
    }

    public MasterDetailsContentNodePart findNode(String label) {
        for (MasterDetailsContentNodePart child : this.nodes()) {
            if (!label.equalsIgnoreCase(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    public MasterDetailsContentNodePart findNode(Element element) {
        if (this.getModelElement() == element) {
            return this;
        }
        for (MasterDetailsContentNodePart child : this.nodes()) {
            MasterDetailsContentNodePart res = child.findNode(element);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void refreshNodes() {
        ListFactory nodeListFactory = ListFactory.start();
        for (Object entry : this.rawChildren) {
            if (entry instanceof MasterDetailsContentNodePart) {
                nodeListFactory.add((Object)((MasterDetailsContentNodePart)entry));
                continue;
            }
            if (entry instanceof NodeFactory) {
                nodeListFactory.add(((NodeFactory)entry).nodes());
                continue;
            }
            throw new IllegalStateException(entry.getClass().getName());
        }
        MasterDetailsContentNodeList nodes = new MasterDetailsContentNodeList(nodeListFactory.result());
        if (this.nodes == null) {
            this.nodes = nodes;
        } else if (!this.nodes.equals(nodes)) {
            this.nodes = nodes;
            this.broadcast(new NodeListEvent(this));
        }
        this.refreshValidation();
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.EditorPage.Outline.Node");
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory validation = Status.factoryForComposite();
        for (SapphirePart sapphirePart : this.sections) {
            if (!sapphirePart.visible()) continue;
            validation.merge(sapphirePart.validation());
        }
        for (SapphirePart sapphirePart : this.nodes()) {
            if (!sapphirePart.visible()) continue;
            validation.merge(sapphirePart.validation());
        }
        for (NodeFactory nodeFactory : this.factories()) {
            if (!nodeFactory.visible()) continue;
            validation.merge(nodeFactory.property().validation());
        }
        return validation.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart sapphirePart : this.sections) {
            sapphirePart.dispose();
        }
        for (SapphirePart sapphirePart : this.nodes()) {
            sapphirePart.dispose();
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.imageManager != null) {
            this.imageManager.dispose();
        }
        for (Object object : this.rawChildren) {
            if (!(object instanceof NodeFactory)) continue;
            ((NodeFactory)object).dispose();
        }
    }

    public boolean controls(Element element) {
        ISapphirePart parentPart;
        if (element == this.getModelElement() && (parentPart = this.parent()) != null && parentPart instanceof MasterDetailsContentNodePart) {
            MasterDetailsContentNodePart parentNode = (MasterDetailsContentNodePart)parentPart;
            return element != parentNode.getLocalModelElement();
        }
        return false;
    }

    public final class NodeFactory {
        private final Property property;
        private final Listener propertyListener;
        private final MasterDetailsContentNodeFactoryDef definition;
        private final Map<String, String> params;
        private final FunctionResult visibleWhenFunctionResult;
        private final Function visibleWhenFunctionForNodes;
        private final Map<Element, MasterDetailsContentNodePart> nodesCache = new IdentityHashMap<Element, MasterDetailsContentNodePart>();
        private final ListenerContext listeners = new ListenerContext();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NodeFactory(MasterDetailsContentNodeFactoryDef definition, Map<String, String> params) {
            ModelPath path = new ModelPath(MasterDetailsContentNodePart.substituteParams((String)definition.getProperty().content(), params));
            Element element = MasterDetailsContentNodePart.this.getLocalModelElement();
            Property p = null;
            int i = 0;
            int n = path.length();
            while (i < n) {
                if (p != null) {
                    throw new RuntimeException(path.toString());
                }
                ModelPath.Segment segment = path.segment(i);
                if (segment instanceof ModelPath.ModelRootSegment) {
                    element = element.root();
                } else if (segment instanceof ModelPath.ParentElementSegment) {
                    element = element.parent().element();
                } else {
                    if (!(segment instanceof ModelPath.PropertySegment)) throw new RuntimeException(path.toString());
                    Property property = element.property(((ModelPath.PropertySegment)segment).getPropertyName());
                    if (property != null && property.definition() instanceof ImpliedElementProperty) {
                        element = ((ElementHandle)property).content();
                    } else {
                        if (!(property instanceof ElementList) && !(property instanceof ElementHandle)) throw new RuntimeException(path.toString());
                        p = property;
                    }
                }
                ++i;
            }
            if (p == null) {
                throw new RuntimeException(path.toString());
            }
            this.property = p;
            this.propertyListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof PropertyContentEvent) {
                        MasterDetailsContentNodePart.this.refreshNodes();
                    } else if (event instanceof PropertyValidationEvent) {
                        SwtUtil.runOnDisplayThread(new Runnable(){

                            @Override
                            public void run() {
                                MasterDetailsContentNodePart.this.refreshValidation();
                            }
                        });
                    }
                }
            };
            this.property.attach(this.propertyListener);
            this.definition = definition;
            this.params = params;
            this.visibleWhenFunctionResult = MasterDetailsContentNodePart.this.initExpression(AndFunction.create((Function[])new Function[]{(Function)definition.getVisibleWhen().content(), MasterDetailsContentNodePart.createVersionCompatibleFunction(this.property)}), Boolean.class, (Function)Literal.TRUE, new Runnable(){

                @Override
                public void run() {
                    NodeFactory.this.broadcast(new PartVisibilityEvent(null));
                }
            });
            this.visibleWhenFunctionForNodes = new Function(){

                public String name() {
                    return "NodeFactoryVisible";
                }

                public FunctionResult evaluate(FunctionContext context) {
                    return new FunctionResult(this, context){
                        private Listener listener;

                        protected void init() {
                            this.listener = new Listener(){

                                public void handle(Event event) {
                                    this.refresh();
                                }
                            };
                            NodeFactory.this.visibleWhenFunctionResult.attach(this.listener);
                        }

                        protected Object evaluate() {
                            return NodeFactory.this.visible();
                        }

                        public void dispose() {
                            super.dispose();
                            NodeFactory.this.visibleWhenFunctionResult.detach(this.listener);
                        }
                    };
                }
            };
            this.visibleWhenFunctionForNodes.init(new Function[0]);
        }

        public final boolean visible() {
            return (Boolean)this.visibleWhenFunctionResult.value();
        }

        public Property property() {
            return this.property;
        }

        protected List<Element> elements() {
            ListFactory elementsListFactory = ListFactory.start();
            if (this.property instanceof ElementList) {
                for (Element element : (ElementList)this.property) {
                    elementsListFactory.add((Object)element);
                }
            } else {
                elementsListFactory.add((Object)((ElementHandle)this.property).content());
            }
            return elementsListFactory.result();
        }

        public final List<MasterDetailsContentNodePart> nodes() {
            ListFactory nodes = ListFactory.start();
            for (Map.Entry<Element, MasterDetailsContentNodePart> entry : this.nodesCache.entrySet()) {
                Element element = entry.getKey();
                MasterDetailsContentNodePart node = entry.getValue();
                if (!element.disposed()) continue;
                node.dispose();
            }
            for (Element element : this.elements()) {
                MasterDetailsContentNodePart node = this.nodesCache.get(element);
                if (node == null) {
                    MasterDetailsContentNodeFactoryCaseDef relevantCaseDef = null;
                    for (MasterDetailsContentNodeFactoryCaseDef entry : this.definition.getCases()) {
                        JavaType type = (JavaType)entry.getElementType().resolve();
                        if (type == null) {
                            relevantCaseDef = entry;
                            break;
                        }
                        Class cl = (Class)type.artifact();
                        if (cl != null && !cl.isAssignableFrom(element.getClass())) continue;
                        relevantCaseDef = entry;
                        break;
                    }
                    if (relevantCaseDef == null) {
                        throw new RuntimeException();
                    }
                    node = new MasterDetailsContentNodePart(this.visibleWhenFunctionForNodes);
                    this.nodesCache.put(element, node);
                    node.init(MasterDetailsContentNodePart.this, element, relevantCaseDef, this.params);
                    node.initialize();
                    node.attach(MasterDetailsContentNodePart.this.childPartListener);
                    node.transformLabelCase = false;
                }
                nodes.add((Object)node);
            }
            return nodes.result();
        }

        public final boolean attach(Listener listener) {
            return this.listeners.attach(listener);
        }

        public final boolean detach(Listener listener) {
            return this.listeners.detach(listener);
        }

        protected final void broadcast(Event event) {
            this.listeners.broadcast(event);
        }

        public void dispose() {
            this.property.detach(this.propertyListener);
            if (this.visibleWhenFunctionResult != null) {
                this.visibleWhenFunctionResult.dispose();
            }
        }
    }

    public static final class NodeListEvent
    extends SapphirePart.PartEvent {
        public NodeListEvent(MasterDetailsContentNodePart node) {
            super(node);
        }

        @Override
        public MasterDetailsContentNodePart part() {
            return (MasterDetailsContentNodePart)super.part();
        }
    }
}

