/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.KeyBindingBehavior;
import org.eclipse.sapphire.ui.def.SapphireKeySequence;
import org.eclipse.sapphire.ui.forms.swt.RadioButtonsGroup;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireHotSpotsActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public final class SapphireKeyboardActionPresentation
extends SapphireHotSpotsActionPresentation {
    private final List<Widget> attachedControls = new ArrayList<Widget>();
    private Listener keyListener;
    private Listener traverseListener;

    public SapphireKeyboardActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    public void attach(final Control control) {
        if (control.getClass() != Composite.class && !(control instanceof RadioButtonsGroup)) {
            this.attachedControls.add((Widget)control);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SapphireKeyboardActionPresentation.this.detach(control);
                }
            });
        }
    }

    public void detach(Control control) {
        this.attachedControls.remove(control);
    }

    @Override
    public void render() {
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                SapphireKeyboardActionPresentation.this.handleKeyEvent(event);
            }
        };
        this.traverseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof ToolBar) {
                    event.doit = true;
                }
            }
        };
        for (Widget control : this.attachedControls) {
            if (control.getClass() == Composite.class) continue;
            control.addListener(1, this.keyListener);
            control.addListener(31, this.traverseListener);
        }
    }

    private void handleKeyEvent(Event event) {
        SapphireActionGroup localGroupOfActions = this.getManager().getActionGroup();
        if (this.handleKeyEvent(event, localGroupOfActions, false)) {
            return;
        }
        ISapphirePart part = localGroupOfActions.getPart();
        while (part != null) {
            SapphireActionGroup groupOfActions;
            String mainActionContext = part.getMainActionContext();
            if (mainActionContext != null && this.handleKeyEvent(event, groupOfActions = part.getActions(mainActionContext), true)) {
                return;
            }
            part = part.parent();
        }
    }

    private boolean handleKeyEvent(Event event, SapphireActionGroup groupOfActions, boolean onlyPropagatedKeyBindings) {
        for (SapphireAction action : groupOfActions.getActions()) {
            SapphireKeySequence keySequence;
            if (!action.hasActiveHandlers() || onlyPropagatedKeyBindings && action.getKeyBindingBehavior() != KeyBindingBehavior.PROPAGATED || (keySequence = action.getKeyBinding()) == null) continue;
            int expectedStateMask = 0;
            for (SapphireKeySequence.Modifier modifier : keySequence.getModifiers()) {
                if (modifier == SapphireKeySequence.Modifier.SHIFT) {
                    expectedStateMask |= 0x20000;
                    continue;
                }
                if (modifier == SapphireKeySequence.Modifier.ALT) {
                    expectedStateMask |= 0x10000;
                    continue;
                }
                if (modifier != SapphireKeySequence.Modifier.CONTROL) continue;
                expectedStateMask |= 0x40000;
            }
            if (event.stateMask != expectedStateMask || event.keyCode != keySequence.getKeyCode()) continue;
            List<SapphireActionHandler> handlers = action.getActiveHandlers();
            if (handlers.size() == 1) {
                final SapphireActionHandler handler = handlers.get(0);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        handler.execute(SapphireKeyboardActionPresentation.this.getManager().context());
                    }
                };
                ((SwtPresentation)this.getManager().context()).display().asyncExec(runnable);
            } else {
                for (SapphireActionPresentation presentation : this.getManager().getPresentations()) {
                    if (presentation.displayActionHandlerChoice(action)) break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Widget widget : this.attachedControls) {
            if (widget.isDisposed()) continue;
            widget.removeListener(1, this.keyListener);
            widget.removeListener(31, this.traverseListener);
        }
        this.attachedControls.clear();
    }
}

