/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.ui.services.internal;

import java.io.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.StatusException;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.LayoutPersistence;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayoutPersistenceService;

public class WorkspaceDiagramLayoutPersistenceService
extends StandardDiagramLayoutPersistenceService {
    private static final String WORKSPACE_LAYOUT_FOLDER = ".metadata/.plugins/org.eclipse.sapphire.ui.diagram/layouts";

    protected StandardDiagramLayout initLayoutModel() {
        StandardDiagramLayout layoutModel = null;
        try {
            String fileName = this.computeLayoutFileName(this.editorInput);
            if (fileName != null) {
                File layoutFile = this.getLayoutPersistenceFile(fileName);
                XmlResourceStore resourceStore = new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(layoutFile));
                layoutModel = (StandardDiagramLayout)StandardDiagramLayout.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
            }
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return layoutModel;
    }

    private File getLayoutPersistenceFile(String fileName) throws StatusException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        File layoutFolder = workspaceRoot.getLocation().toFile();
        if (!(layoutFolder = new File(layoutFolder, WORKSPACE_LAYOUT_FOLDER)).exists()) {
            FileUtil.mkdirs((File)layoutFolder);
        }
        File layoutFile = new File(layoutFolder, fileName);
        return layoutFile;
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            SapphireDiagramEditorPagePart diagramPagePart;
            DiagramEditorPageDef pageDef;
            ISapphirePart part = (ISapphirePart)context.find(ISapphirePart.class);
            return part instanceof SapphireDiagramEditorPagePart && (pageDef = (diagramPagePart = (SapphireDiagramEditorPagePart)part).getPageDef()).getLayoutPersistence().content() == LayoutPersistence.WORKSPACE;
        }
    }
}

