/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.index;

import java.util.Set;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Index;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.index.TestElement;
import org.eclipse.sapphire.tests.index.TestElementWithEqualityService;
import org.eclipse.sapphire.tests.index.TestElementWithInheritedProperty;
import org.junit.Test;

public final class IndexTests
extends SapphireTestCase {
    @Test
    public void testSingleIndex() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i));
                ++i;
            }
            Index index = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            IndexTests.assertSame(list, (Object)index.list());
            IndexTests.assertSame((Object)TestElement.ListEntry.PROP_STRING_VALUE, (Object)index.property());
            IndexTests.assertSame((Object)index, (Object)list.index(TestElement.ListEntry.PROP_STRING_VALUE));
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "20", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "97", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "137", 0);
            int i2 = 100;
            while (i2 < 200) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i2));
                ++i2;
            }
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "137", 1);
            i2 = 100;
            while (i2 < 200) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i2));
                ++i2;
            }
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "20", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "97", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "137", 2);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "182", 2);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "213", 0);
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testMultipleIndexes() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                TestElement.ListEntry entry = (TestElement.ListEntry)list.insert();
                entry.setStringValue("s" + String.valueOf(i));
                entry.setIntegerValue(i);
                ++i;
            }
            Index stringValueIndex = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            IndexTests.assertSame(list, (Object)stringValueIndex.list());
            IndexTests.assertSame((Object)TestElement.ListEntry.PROP_STRING_VALUE, (Object)stringValueIndex.property());
            IndexTests.assertSame((Object)stringValueIndex, (Object)list.index(TestElement.ListEntry.PROP_STRING_VALUE));
            Index integerValueIndex = list.index(TestElement.ListEntry.PROP_INTEGER_VALUE);
            IndexTests.assertSame(list, (Object)integerValueIndex.list());
            IndexTests.assertSame((Object)TestElement.ListEntry.PROP_INTEGER_VALUE, (Object)integerValueIndex.property());
            IndexTests.assertSame((Object)integerValueIndex, (Object)list.index(TestElement.ListEntry.PROP_INTEGER_VALUE));
            IndexTests.assertSame((Object)stringValueIndex.element("s97"), (Object)integerValueIndex.element("97"));
            int i2 = 100;
            while (i2 < 200) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i2));
                ++i2;
            }
            IndexTests.assertSame((Object)stringValueIndex.element("s137"), (Object)integerValueIndex.element("137"));
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testIndexEvents() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                TestElement.ListEntry entry = (TestElement.ListEntry)list.insert();
                entry.setStringValue(String.valueOf(i));
                entry.setIntegerValue(i);
                ++i;
            }
            Index index = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            EventLog log = new EventLog();
            index.attach((Listener)log);
            index.element("1");
            IndexTests.assertEquals((long)0L, (long)log.size());
            list.remove(0);
            IndexTests.assertEquals((long)1L, (long)log.size());
            log.clear();
            ((TestElement.ListEntry)list.get(10)).setStringValue("aa");
            IndexTests.assertEquals((long)1L, (long)log.size());
            log.clear();
            ((TestElement.ListEntry)list.get(10)).setIntegerValue(9999);
            IndexTests.assertEquals((long)0L, (long)log.size());
            list.moveUp(list.get(10));
            IndexTests.assertEquals((long)0L, (long)log.size());
            list.moveDown(list.get(20));
            IndexTests.assertEquals((long)0L, (long)log.size());
            index.detach((Listener)log);
            list.remove(0);
            IndexTests.assertEquals((long)0L, (long)log.size());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testIndexWithEqualityService() {
        TestElementWithEqualityService element = (TestElementWithEqualityService)TestElementWithEqualityService.TYPE.instantiate();
        try {
            ElementList<TestElementWithEqualityService.ListEntry> list = element.getList();
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("a");
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("b");
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("a");
            Index index = list.index(TestElementWithEqualityService.ListEntry.PROP_VALUE);
            IndexTests.assertEquals((long)2L, (long)index.elements("a").size());
            IndexTests.assertEquals((long)1L, (long)index.elements("b").size());
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("b");
            IndexTests.assertEquals((long)2L, (long)index.elements("b").size());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testIndexWithInheritedProperty() {
        TestElementWithInheritedProperty element = (TestElementWithInheritedProperty)TestElementWithInheritedProperty.TYPE.instantiate();
        try {
            ElementList<TestElementWithInheritedProperty.ListEntry> list = element.getList();
            ((TestElementWithInheritedProperty.ListEntry)list.insert()).setValue("a");
            ((TestElementWithInheritedProperty.ListEntry)list.insert()).setValue("b");
            Index index = list.index(TestElementWithInheritedProperty.ListEntry.PROP_VALUE);
            IndexTests.assertNotNull((Object)index.element("a"));
            IndexTests.assertNotNull((Object)index.element("b"));
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_ValueProperty_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(null);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_ValueProperty_Foreign_1() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(TestElement.PROP_VALUE);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_ValueProperty_Foreign_2() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(TestElement.ListEntry.NestedListEntry.PROP_VALUE);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_ElementList_Index_ValueProperty_Disposed() {
        ElementList<TestElement.ListEntry> list;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            list = element.getList();
        }
        finally {
            element.dispose();
        }
        list.index(TestElement.ListEntry.PROP_STRING_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(null);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_Unknown() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index("Value");
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_Path() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index("List/Value");
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_List() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index("List");
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_ElementList_Index_String_Disposed() {
        ElementList<TestElement.ListEntry> list;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            list = element.getList();
        }
        finally {
            element.dispose();
        }
        list.index(TestElement.ListEntry.PROP_STRING_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_Index_Element_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE).element(null);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_Index_Element_Disposed() {
        Index index;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            index = element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE);
        }
        finally {
            element.dispose();
        }
        index.element("a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_Index_Elements_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE).elements(null);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_Index_Elements_Disposed() {
        Index index;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            index = element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE);
        }
        finally {
            element.dispose();
        }
        index.elements("a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_Index_Attach_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE).attach(null);
        }
        finally {
            element.dispose();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_Index_Attach_Disposed() {
        Index index;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            index = element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE);
        }
        finally {
            element.dispose();
        }
        index.attach((Listener)new EventLog());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_Index_Detach_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE).detach(null);
        }
        finally {
            element.dispose();
        }
    }

    private void testIndexLookup(Index<TestElement.ListEntry> index, String key, int count) {
        if (count == 0) {
            IndexTests.assertNull((Object)index.element(key));
            Set elements = index.elements(key);
            IndexTests.assertNotNull((Object)elements);
            IndexTests.assertEquals((long)0L, (long)elements.size());
        } else {
            TestElement.ListEntry element = (TestElement.ListEntry)index.element(key);
            IndexTests.assertNotNull((Object)element);
            IndexTests.assertEquals((Object)key, (Object)element.property(index.property()).text());
            Set elements = index.elements(key);
            IndexTests.assertNotNull((Object)elements);
            IndexTests.assertEquals((long)count, (long)elements.size());
            for (TestElement.ListEntry entry : elements) {
                IndexTests.assertEquals((Object)key, (Object)entry.property(index.property()).text());
            }
        }
    }
}

