/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.actions;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public final class SaveAsImageDiagramActionHandler
extends SapphireActionHandler {
    @Text(value="Save as Image")
    private static LocalizableText saveAsImageMessage;

    static {
        LocalizableText.init(SaveAsImageDiagramActionHandler.class);
    }

    protected Object run(Presentation context) {
        block25: {
            DiagramPresentation diagramPresentation = (DiagramPresentation)context;
            SapphireDiagramEditor diagramEditor = diagramPresentation.getConfigurationManager().getDiagramEditor();
            if (diagramEditor != null) {
                FileDialog dialog = new FileDialog(diagramEditor.getSite().getShell(), 8192);
                IEditorInput editorInput = (IEditorInput)diagramEditor.getPart().adapt(IEditorInput.class);
                if (editorInput instanceof IFileEditorInput) {
                    dialog.setFilterPath(((IFileEditorInput)editorInput).getFile().getParent().getLocation().toOSString());
                }
                String editorInputName = editorInput.getName();
                int editorInputLastDot = editorInputName.lastIndexOf(46);
                StringBuilder initialFileName = new StringBuilder();
                if (editorInputLastDot == -1) {
                    initialFileName.append(editorInputName);
                } else {
                    initialFileName.append(editorInputName.substring(0, editorInputLastDot));
                }
                initialFileName.append(".png");
                dialog.setFileName(initialFileName.toString());
                dialog.setFilterExtensions(new String[]{"*.png"});
                dialog.setText(saveAsImageMessage.text());
                dialog.setOverwrite(true);
                String filePath = dialog.open();
                if (filePath == null) {
                    return null;
                }
                GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
                ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)graphicalViewer.getRootEditPart();
                IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
                Rectangle rectangle = figure.getBounds();
                Image image = new Image((Device)diagramPresentation.display(), rectangle.width, rectangle.height);
                FileOutputStream output = null;
                GC gc = null;
                SWTGraphics graphics = null;
                try {
                    try {
                        gc = new GC((Drawable)image);
                        graphics = new SWTGraphics(gc);
                        figure.paint((Graphics)graphics);
                        ImageLoader loader = new ImageLoader();
                        loader.data = new ImageData[]{image.getImageData()};
                        output = new FileOutputStream(filePath);
                        loader.save((OutputStream)output, 5);
                        output.flush();
                    }
                    catch (Exception e) {
                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                        image.dispose();
                        if (gc != null) {
                            gc.dispose();
                        }
                        if (graphics != null) {
                            graphics.dispose();
                        }
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    image.dispose();
                    if (gc != null) {
                        gc.dispose();
                    }
                    if (graphics != null) {
                        graphics.dispose();
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                image.dispose();
                if (gc != null) {
                    gc.dispose();
                }
                if (graphics != null) {
                    graphics.dispose();
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

