/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.ui.services.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.LayoutPersistence;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayoutPersistenceService;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SideBySideDiagramLayoutPersistenceService
extends StandardDiagramLayoutPersistenceService {
    protected StandardDiagramLayout initLayoutModel() {
        StandardDiagramLayout layoutModel = null;
        try {
            String fileName = this.computeLayoutFileName(this.editorInput);
            if (fileName != null) {
                XmlResourceStore resourceStore;
                if (this.editorInput instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)this.editorInput;
                    IFolder layoutFolder = (IFolder)fileInput.getFile().getParent();
                    IFile layoutFile = layoutFolder.getFile(fileName);
                    resourceStore = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(layoutFile));
                } else if (this.editorInput instanceof FileStoreEditorInput) {
                    FileStoreEditorInput fileStoreInput = (FileStoreEditorInput)this.editorInput;
                    IFileStore store = EFS.getStore((URI)fileStoreInput.getURI());
                    File localFile = store.toLocalFile(0, null);
                    if (localFile == null) {
                        localFile = store.toLocalFile(4096, null);
                    }
                    if (localFile == null) {
                        throw new IllegalArgumentException();
                    }
                    File layoutFile = new File(localFile.getParentFile(), fileName);
                    resourceStore = new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(layoutFile));
                } else {
                    throw new IllegalStateException();
                }
                layoutModel = (StandardDiagramLayout)StandardDiagramLayout.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
            }
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return layoutModel;
    }

    protected String computeLayoutFileName(IEditorInput editorInput) throws CoreException, IOException {
        String fileName = null;
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            IFile ifile = fileEditorInput.getFile();
            fileName = ifile.getName();
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreInput = (FileStoreEditorInput)editorInput;
            IFileStore store = EFS.getStore((URI)fileStoreInput.getURI());
            File localFile = store.toLocalFile(0, null);
            if (localFile == null) {
                localFile = store.toLocalFile(4096, null);
            }
            if (localFile == null) {
                throw new IllegalArgumentException();
            }
            fileName = localFile.getName();
        }
        if (fileName != null && fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.indexOf(".xml"));
        }
        if (fileName != null) {
            fileName = String.valueOf(fileName) + ".layout";
        }
        return fileName;
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            SapphireDiagramEditorPagePart diagramPagePart;
            DiagramEditorPageDef pageDef;
            ISapphirePart part = (ISapphirePart)context.find(ISapphirePart.class);
            return part instanceof SapphireDiagramEditorPagePart && (pageDef = (diagramPagePart = (SapphireDiagramEditorPagePart)part).getPageDef()).getLayoutPersistence().content() == LayoutPersistence.SIDE_BY_SIDE;
        }
    }
}

